% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulate.R
\name{split_block}
\alias{split_block}
\title{Split a block bounding box}
\usage{
split_block(block_df, page = 1, block, cut_point, direction = "v")
}
\arguments{
\item{block_df}{A dataframe generated by \code{build_block_df()}.}

\item{page}{The number of the page where the split will be made.
Defaults to 1.}

\item{block}{The number of the block to be split.}

\item{cut_point}{A number between 0 and 100, where 0 is the
existing left/top limit and 100 is the existing right/bottom limit.}

\item{direction}{"V" for vertical split or "H" for horizontal split.
Defaults to "V".}
}
\value{
a block data frame
}
\description{
This function 'splits' (in the sense of changing the
coordinates) of an existing block bounding box vertically or
horizontally at a specified point. It takes a block data frame as
input and modifies it. The splitting produces a new block, which
is added to the data frame while the old block's coordinates are
updated. The function returns a revised block data frame.
}
\examples{
\dontrun{
new_block_df <- split_block(df = old_block_df, block = 7, cut_point = 33)
}
}
