% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fingerprint.R
\name{fingerprint}
\alias{fingerprint}
\title{Optimal Fingerprinting via total least square regression.}
\usage{
fingerprint(
  X,
  Y,
  cov,
  nruns.X,
  ctlruns,
  precision = FALSE,
  conf.level = 0.9,
  conf.method = c("none", "TSB", "PBC", "both"),
  cov.method = c("l2", "mv"),
  B = 1000
)
}
\arguments{
\item{X}{signal pattern to be detected.}

\item{Y}{observed data.}

\item{cov}{Weight matrix used in prewhitening process, can be estimate of 
covariance matrix or precision matrix.}

\item{nruns.X}{number of ensembles to estimate the corresponding pattern. 
It is used as the scale of the covariance matrix for Xi.}

\item{ctlruns}{a group of independent control runs for estimating 
covariance matrix, which is used in two stage bootstrap and the parametric 
bootstrap calibration.}

\item{precision}{indicator for precision matrix, if precision 
matrix estimate is used, precision should be set to TRUE.}

\item{conf.level}{confidence level for confidence interval estimation.}

\item{conf.method}{method for calibrating the confidence intervals, including
no calibration (none), two stage bootstrap (TSB), and parametric bootstrap calibration (PBC).}

\item{cov.method}{method for estimation of covariance matrix in confidence 
interval procedure. It should be consistent to the method to get cov. (only valid if TSB or PBC is considered.)}

\item{B}{number of replicates in two stage bootstrap and/or parametric bootstrap calibration, 
default value is 1000. (only valid if TSB or PBC is considered.)}
}
\value{
a list of the fitted model including point estimate and
interval estimate of coefficients and corresponding estimate of 
standard error.
}
\description{
This function detects the signal factors on the observed data via total 
least square linear regression model.
}
\examples{
data(simDat)
## set the true covariance matrix and expected pattern
Cov <- simDat$Cov[[1]]
ANT <- simDat$X[, 1]
NAT <- simDat$X[, 2]
## estimate the covariance matrix
Z <- MASS::mvrnorm(100, mu = rep(0, nrow(Cov)), Sigma = Cov)
## linear shrinkage estimator under l2 loss
Cov.est <- Covest(Z, method = "l2")$output
## generate regression observation and pattern
nruns.X <- c(1, 1)
Y <- MASS::mvrnorm(n = 1, mu = ANT + NAT, Sigma = Cov)
X <- cbind(MASS::mvrnorm(n = 1, mu = ANT, Sigma = Cov),
           MASS::mvrnorm(n = 1, mu = NAT, Sigma = Cov))
fingerprint(X, Y, Cov.est, nruns.X, ctlruns = Z, conf.method = "TSB", B = 5)
}
\references{
\itemize{ 
\item  Gleser (1981), Estimation in a Multivariate "Errors in Variables" 
Regression Model: Large Sample Results, \emph{Ann. Stat.} 9(1) 24--44.
\item Golub and Laon (1980), An Analysis of the Total Least Squares Problem,
\emph{SIAM J. Numer. Anal}. 17(6) 883--893.
\item Pesta (2012), Total least squares and bootstrapping with 
applications in calibration, \emph{Statistics} 47(5), 966--991.
\item Li et al (2021), Uncertainty in Optimal Fingerprinting is Underestimated, \emph{Environ. Res. Lett.} 16(8) 084043.}
}
\author{
Yan Li
}
\keyword{fingerprinting}
\keyword{regression}
\keyword{tls}
