% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_dm.R, R/extended_s3_methods.R,
%   R/formatting_coefs_dm.R
\name{coef<-}
\alias{coef<-}
\alias{coef<-.drift_dm}
\alias{coef.drift_dm}
\alias{coef.fits_ids_dm}
\alias{print.coefs_dm}
\title{Access Coefficients of a Model}
\usage{
coef(object, ...) <- value

\method{coef}{drift_dm}(object, ..., eval_model = FALSE) <- value

\method{coef}{drift_dm}(object, ..., select_unique = TRUE, select_custom_prms = TRUE)

\method{coef}{fits_ids_dm}(object, ...)

\method{print}{coefs_dm}(
  x,
  ...,
  round_digits = drift_dm_default_rounding(),
  print_rows = 10,
  some = FALSE,
  show_header = TRUE,
  show_note = TRUE
)
}
\arguments{
\item{object}{an object of type \link{drift_dm} or \code{fits_ids_dm}
(see \link{load_fits_ids}).}

\item{...}{additional arguments passed to the respective method.}

\item{value}{numerical, a vector with valid values to update the model's
parameters. Must match with the number of (unique and free) parameters.}

\item{eval_model}{logical, indicating if the model should be re-evaluated or
not when updating the parameters (see \link{re_evaluate_model}).
Default is \code{FALSE}.}

\item{select_unique}{logical, indicating if only those parameters shall be
returned that are considered unique (e.g., when a parameter is set to be
identical across three conditions, then the parameter is only returned once).
Default is \code{TRUE}. This will also return only those parameters that are
estimated.}

\item{select_custom_prms}{logical, indicating if custom parameters shall be
returned as well. Only has an effect if \code{select_unique = FALSE}.}

\item{x}{an object of type \code{coefs_dm}, as returned by the function
\code{coef()} when supplied with a \code{fits_ids_dm} object.}

\item{round_digits}{integer, controls the number of digits shown.
Default is 3.}

\item{print_rows}{integer, controls the number of rows shown.}

\item{some}{logical. If \code{TRUE}, a subset of randomly sampled rows is shown.}

\item{show_header}{logical. If \code{TRUE}, a header specifying the type of
statistic will be displayed.}

\item{show_note}{logical. If \code{TRUE}, a footnote  is displayed indicating
that the underlying \link{data.frame} can be accessed as usual.}
}
\value{
For objects of type \link{drift_dm}, \code{coefs()} returns either a named
numeric vector if \code{select_unique = TRUE}, or a matrix if
\code{select_unique = FALSE}. If \code{select_custom_prms = TRUE}, custom parameters
are added to the matrix.

For objects of type \code{fits_ids_dm}, \code{coefs()} returns a \link{data.frame}. If
\code{select_unique = TRUE}, the columns will be the (unique, free) parameters,
together with a column coding \code{IDs}. If \code{select_unique = FALSE}, the columns
will be the parameters as listed in the columns of \code{prms_matrix} (see
\link{drift_dm}), together with columns coding the conditions and
\code{IDs}. If \code{select_custom_prms = TRUE}, the \link{data.frame} will also contain
columns for the custom parameters. The returned \link{data.frame} has the class
label \code{coefs_dm} to easily plot histograms for each parameter
(see \link{hist.coefs_dm}).
}
\description{
Extract or set the coefficients/parameters of \link{drift_dm} or
\code{fits_ids_dm} objects
}
\details{
\code{coef()} are methods for the generic \code{coef} function; \verb{coefs<-()} is a
generic replacement function, currently supporting objects of type
\link{drift_dm}.

The argument \code{value} supplied to the \verb{coefs<-()} function must match with
the vector returned from \verb{coef(<object>)}. It is possible to
update just part of the (unique) parameters.

Whenever the argument \code{select_unique = TRUE}, dRiftDM tries to provide
unique parameter labels.
}
\examples{
# get a pre-built model and a data set for demonstration purpose
# (when creating the model, set the discretization to reasonable values)
a_model <- dmc_dm(t_max = 1.5, dx = .0025, dt = .0025)
coef(a_model) # gives the free and unique parameters
coef(a_model, select_unique = FALSE) # gives the entire parameter matrix

}
\seealso{
\code{\link[=drift_dm]{drift_dm()}}
}
