% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_area_search}
\alias{cvd_area_search}
\title{Search for matching areas}
\usage{
cvd_area_search(partial_area_name = "Surgery", time_period_id = 1)
}
\arguments{
\item{partial_area_name}{string - string to use to search for an Area (compulsory)}

\item{time_period_id}{integer - limits the search to Areas which have data in specified time period (compulsory)}
}
\value{
Tibble of details for areas matching the search term
}
\description{
Returns a list of Areas that match a partial name for a given time period.
Uses simple LIKE '\%<partial_area_name>\%' comparison.
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Farea\%2Fsearch}{Area search}
}
\examples{
# NB, the following examples are not tested because they take longer than
# expected to return the results

# search for areas matching the term 'practice'
\donttest{cvd_area_search(partial_area_name = 'practice', time_period_id = 17) |>
  dplyr::select(AreaID, AreaName, AreaCode)}

# search for areas matching the term 'PCN'
\donttest{cvd_area_search(partial_area_name = 'PCN', time_period_id = 17) |>
  dplyr::select(AreaID, AreaName, AreaCode)}
}
\seealso{
\code{\link[=cvd_area_list]{cvd_area_list()}}, \code{\link[=cvd_area_details]{cvd_area_details()}}, \code{\link[=cvd_area_unassigned]{cvd_area_unassigned()}}, \code{\link[=cvd_area_nested_subsystems]{cvd_area_nested_subsystems()}}, \code{\link[=cvd_area_flat_subsystems]{cvd_area_flat_subsystems()}}
}
