% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect.R
\name{fx}
\alias{fx}
\alias{fx,ANY-method}
\alias{fx,GutsRedSd-method}
\alias{fx,GutsRedIt-method}
\alias{fx,Lemna-method}
\alias{fx,Myriophyllum-method}
\alias{fx,Algae-method}
\title{Generic to calculate effects for a particular scenario}
\usage{
fx(scenario, ...)

\S4method{fx}{ANY}(scenario, ...)

\S4method{fx}{GutsRedSd}(scenario, ...)

\S4method{fx}{GutsRedIt}(scenario, ...)

\S4method{fx}{Lemna}(scenario, ...)

\S4method{fx}{Myriophyllum}(scenario, ...)

\S4method{fx}{Algae}(scenario, ...)
}
\arguments{
\item{scenario}{\link{scenario} object}

\item{...}{additional parameters}
}
\value{
numeric named vector
}
\description{
Generic to calculate effects for a particular scenario
}
\section{Methods (by class)}{
\itemize{
\item \code{fx(ANY)}: Use state variables at end of simulation

\item \code{fx(GutsRedSd)}: Effect at end of simulation of \link{GUTS-RED-models}

\item \code{fx(GutsRedIt)}: Effect at end of simulation of \link{GUTS-RED-models}

\item \code{fx(Lemna)}: Effect at end of simulation of \link{Lemna-models}

\item \code{fx(Myriophyllum)}: Effect at end of simulation of \link{Macrophyte-models}

\item \code{fx(Algae)}: Effect at end of simulation of \link{Algae-models}

}}
