% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvar-package.R
\docType{package}
\name{cvar-package}
\alias{cvar-package}
\alias{cvar}
\title{Compute Conditional Value-at-Risk and Value-at-Risk}
\description{
Compute expected shortfall (ES) and Value at Risk (VaR)
    from a quantile function, distribution function, random number
    generator or probability density function.  ES is also known as
    Conditional Value at Risk (CVaR). Virtually any continuous
    distribution can be specified.  The functions are vectorised over
    the arguments. Some support for GARCH models is provided, as well.
}
\details{
There is a huge number of functions for computations with
    distributions in core \R and in contributed packages. Pdf's,
    cdf's, quantile functions and random number generators are
    covered comprehensively. The coverage of expected shortfall is
    more patchy but a large collection of distributions, including
    functions for expected shortfall, is provided by
    \insertCite{VaRES2013;textual}{cvar}.
    \insertCite{PerformanceAnalytics2018;textual}{cvar} and
    \insertCite{actuarJSS2008;textual}{cvar} provide packages
    covering comprehensively various aspects of risk measurement,
    including some functions for expected shortfall.

    Package \pkg{cvar} is a small package with, essentially, two main
    functions --- \code{ES} for computing the expected shortfall
    and \code{VaR} for Value at Risk.  The user specifies the
    distribution by supplying one of the functions that define a
    continuous distribution---currently this can be a quantile
    function (qf), cumulative distribution function (cdf) or
    probability density function (pdf). Virtually any continuous
    distribution can be specified.

    The functions are vectorised over the parameters of the
    distributions, making bulk computations more convenient, for
    example for forecasting or model evaluation.

    The name of this package, "cvar", comes from \emph{Conditional
    Value at Risk} (CVaR), which is an alternative term for
    expected shortfall.

    We chose to use the standard names \code{ES} and \code{VaR},
    despite the possibility for name clashes with same named
    functions in other packages, rather than invent possibly
    difficult to remember alternatives. Just call the functions as
    \code{cvar::ES} and \code{cvar::VaR} if necessary.

    Locations-scale transformations can be specified separately
    from the other distribution parameters. This is useful when
    such parameters are not provided directly by the distribution
    at hand. The use of these parameters often leads to more
    efficient computations and better numerical accuracy even if
    the distribution has its own parameters for this purpose. Some
    of the examples for \code{VaR} and \code{ES} illustrate this
    for the Gaussian distribution.

    Since VaR is a quantile, functions computing it for a given
    distribution are convenience functions. \code{VaR} exported by
    \pkg{cvar} could be attractive in certain workflows because of
    its vectorised distribution parameters, the location-scale
    transformation, and the possibility to compute it from cdf's
    when quantile functions are not available.

    Some support for GARCH models is provided, as well. It is
    currently under development, see \code{\link{predict.garch1c1}}
    for current functionality.
}
\examples{
## see the examples for ES(), VaR(), predict.garch1c1()

}
\references{
\insertAllCited{}

---

This is for pkgdown test. The following two phrases should be in separate paragraphs:

\Sexpr[stage=build,results=rd]{paste0(c("First phrase.", "Second phrase."), collapse = "\n\n")}

---

\Sexpr[stage=build,results=rd]{paste0("First phrase.\n\nSecond phrase.")}
}
\author{
Georgi N. Boshnakov
}
