\name{summary.cv}
\alias{summary.cv}
\alias{summary.cvSelect}
\alias{summary.cvTuning}
\title{Summarize cross-validation results}
\usage{
 \method{summary}{cv} (object, ...)

 \method{summary}{cvSelect} (object, ...)

 \method{summary}{cvTuning} (object, ...)
}
\arguments{
  \item{object}{an object inheriting from class \code{"cv"}
  or \code{"cvSelect"} that contains cross-validation
  results (note that the latter includes objects of class
  \code{"cvTuning"}).}

  \item{\dots}{currently ignored.}
}
\value{
  An object of class \code{"summary.cv"},
  \code{"summary.cvSelect"} or \code{"summary.cvTuning"},
  depending on the class of \code{object}.
}
\description{
  Produce a summary of results from (repeated) \eqn{K}-fold
  cross-validation.
}
\examples{
library("robustbase")
data("coleman")
set.seed(1234)  # set seed for reproducibility

## set up folds for cross-validation
folds <- cvFolds(nrow(coleman), K = 5, R = 10)


## compare raw and reweighted LTS estimators for 
## 50% and 75% subsets

# 50% subsets
fitLts50 <- ltsReg(Y ~ ., data = coleman, alpha = 0.5)
cvFitLts50 <- cvLts(fitLts50, cost = rtmspe, folds = folds, 
    fit = "both", trim = 0.1)

# 75% subsets
fitLts75 <- ltsReg(Y ~ ., data = coleman, alpha = 0.75)
cvFitLts75 <- cvLts(fitLts75, cost = rtmspe, folds = folds, 
    fit = "both", trim = 0.1)

# combine results into one object
cvFitsLts <- cvSelect("0.5" = cvFitLts50, "0.75" = cvFitLts75)
cvFitsLts

# summary of the results with the 50% subsets
summary(cvFitLts50)
# summary of the combined results
summary(cvFitsLts)


## evaluate MM regression models tuned for 
## 80%, 85%, 90% and 95% efficiency
tuning <- list(tuning.psi=c(3.14, 3.44, 3.88, 4.68))

# set up function call
call <- call("lmrob", formula = Y ~ .)
# perform cross-validation
cvFitsLmrob <- cvTuning(call, data = coleman, 
    y = coleman$Y, tuning = tuning, cost = rtmspe, 
    folds = folds, costArgs = list(trim = 0.1))
cvFitsLmrob

# summary of results
summary(cvFitsLmrob)
}
\author{
  Andreas Alfons
}
\seealso{
  \code{\link{cvFit}}, \code{\link{cvSelect}},
  \code{\link{cvTuning}}, \code{\link{summary}}
}
\keyword{utilities}

