% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_metric.R
\name{maximize_loess_metric}
\alias{maximize_loess_metric}
\alias{minimize_loess_metric}
\title{Optimize a metric function in binary classification after LOESS smoothing}
\source{
Xiao-Feng Wang (2010). fANCOVA: Nonparametric Analysis of Covariance.
 https://CRAN.R-project.org/package=fANCOVA

Leeflang, M. M., Moons, K. G., Reitsma, J. B., & Zwinderman, A. H.
(2008). Bias in sensitivity and specificity caused by data-driven selection
of optimal cutoff values: mechanisms, magnitude, and solutions.
Clinical Chemistry, (4), 729–738.
}
\usage{
maximize_loess_metric(data, x, class, metric_func = youden,
  pos_class = NULL, neg_class = NULL, direction, criterion = "aicc",
  degree = 1, family = "symmetric", user.span = NULL, tol_metric,
  use_midpoints, ...)

minimize_loess_metric(data, x, class, metric_func = youden,
  pos_class = NULL, neg_class = NULL, direction, criterion = "aicc",
  degree = 1, family = "symmetric", user.span = NULL, tol_metric,
  use_midpoints, ...)
}
\arguments{
\item{data}{A data frame or tibble in which the columns that are given in x
and class can be found.}

\item{x}{(character) The variable name to be used for classification,
e.g. predictions or test values.}

\item{class}{(character) The variable name indicating class membership.}

\item{metric_func}{(function) A function that computes a
metric to be maximized. See description.}

\item{pos_class}{The value of class that indicates the positive class.}

\item{neg_class}{The value of class that indicates the negative class.}

\item{direction}{(character) Use ">=" or "<=" to select whether an x value
>= or <= the cutoff predicts the positive class.}

\item{criterion}{the criterion for automatic smoothing parameter selection:
"aicc" denotes bias-corrected AIC criterion, "gcv" denotes generalized
cross-validation.}

\item{degree}{the degree of the local polynomials to be used. It can be
0, 1 or 2.}

\item{family}{if "gaussian" fitting is by least-squares, and if "symmetric"
a re-descending M estimator is used with Tukey's biweight function.}

\item{user.span}{The user-defined parameter which controls the degree of
smoothing}

\item{tol_metric}{All cutpoints will be returned that lead to a metric
value in the interval [m_max - tol_metric, m_max + tol_metric] where
m_max is the maximum achievable metric value. This can be used to return
multiple decent cutpoints and to avoid floating-point problems.}

\item{use_midpoints}{(logical) If TRUE (default FALSE) the returned optimal
cutpoint will be the mean of the optimal cutpoint and the next highest
observation (for direction = ">") or the next lowest observation
(for direction = "<") which avoids biasing the optimal cutpoint.}

\item{...}{Further arguments that will be passed to metric_func or the
loess smoother.}
}
\value{
A tibble with the columns \code{optimal_cutpoint}, the corresponding metric
value and \code{roc_curve}, a nested tibble that includes all possible cutoffs
and the corresponding numbers of true and false positives / negatives and
all corresponding metric values.
}
\description{
Given a function for computing a metric in \code{metric_func}, these functions
smooth the function of metric value per cutpoint using LOESS, then
maximize or minimize the metric by selecting an optimal cutpoint. For further details
on the LOESS smoothing see \code{?fANCOVA::loess.as}.
The \code{metric} function should accept the following inputs:
\itemize{
 \item \code{tp}: vector of number of true positives
 \item \code{fp}: vector of number of false positives
 \item \code{tn}: vector of number of true negatives
 \item \code{fn}: vector of number of false negatives
}
}
\details{
The above inputs are arrived at by using all unique values in \code{x}, Inf, and
-Inf as possible cutpoints for classifying the variable in class.
}
\examples{
oc <- cutpointr(suicide, dsi, suicide, gender, method = maximize_loess_metric,
criterion = "aicc", family = "symmetric", degree = 2, user.span = 0.7,
metric = accuracy)
plot_metric(oc)
oc <- cutpointr(suicide, dsi, suicide, gender, method = minimize_loess_metric,
criterion = "aicc", family = "symmetric", degree = 2, user.span = 0.7,
metric = misclassification_cost, cost_fp = 1, cost_fn = 10)
plot_metric(oc)
}
\seealso{
Other method functions: \code{\link{maximize_boot_metric}},
  \code{\link{maximize_gam_metric}},
  \code{\link{maximize_metric}},
  \code{\link{maximize_spline_metric}},
  \code{\link{oc_manual}}, \code{\link{oc_mean}},
  \code{\link{oc_median}}, \code{\link{oc_youden_kernel}},
  \code{\link{oc_youden_normal}}
}
\concept{method functions}
