% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{youden}
\alias{youden}
\title{Calculate the Youden-Index}
\usage{
youden(tp, fp, tn, fn, ...)
}
\arguments{
\item{tp}{(numeric) number of true positives.}

\item{fp}{(numeric) number of false positives.}

\item{tn}{(numeric) number of true negatives.}

\item{fn}{(numeric) number of false negatives.}

\item{...}{for capturing additional arguments passed by method.}
}
\description{
Calculate the Youden-Index (J-Index) from
true positives, false positives, true negatives and false negatives.
The inputs must be vectors of equal length. \cr \cr
sensitivity = tp / (tp + fn) \cr
specificity = tn / (tn + fp) \cr
youden_index = sensitivity + specificity - 1 \cr
}
\examples{
youden(10, 5, 20, 10)
youden(c(10, 8), c(5, 7), c(20, 12), c(10, 18))
}
\seealso{
Other metric functions: \code{\link{F1_score}},
  \code{\link{abs_d_ppv_npv}},
  \code{\link{abs_d_sens_spec}}, \code{\link{accuracy}},
  \code{\link{cohens_kappa}}, \code{\link{cutpoint}},
  \code{\link{false_omission_rate}},
  \code{\link{misclassification_cost}}, \code{\link{npv}},
  \code{\link{odds_ratio}}, \code{\link{p_chisquared}},
  \code{\link{plr}}, \code{\link{ppv}},
  \code{\link{precision}}, \code{\link{prod_ppv_npv}},
  \code{\link{prod_sens_spec}}, \code{\link{recall}},
  \code{\link{risk_ratio}}, \code{\link{roc01}},
  \code{\link{sens_constrain}}, \code{\link{sensitivity}},
  \code{\link{specificity}}, \code{\link{sum_ppv_npv}},
  \code{\link{sum_sens_spec}}, \code{\link{total_utility}},
  \code{\link{tpr}}, \code{\link{tp}}
}
\concept{metric functions}
