% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R, R/utilities.R
\docType{data}
\name{curl_options}
\alias{curl_options}
\alias{curl_version}
\alias{curl_symbols}
\title{List curl version and options.}
\format{A data frame with columns:
\describe{
\item{name}{Symbol name}
\item{introduced,deprecated,removed}{Versions of libcurl}
\item{value}{Integer value of symbol}
\item{type}{If an option, the type of value it needs}
}}
\usage{
curl_options(filter = "")

curl_version()

curl_symbols
}
\arguments{
\item{filter}{string: only return options with string in name}
}
\description{
\code{curl_version()} shows the versions of libcurl, libssl and zlib and
supported protocols. \code{curl_options()} lists all options available in
the current version of libcurl.  The dataset \code{curl_symbols} lists all
symbols (including options) provides more information about the symbols,
including when support was added/removed from libcurl.
}
\examples{
# Available options
curl_options()

# List proxy options
curl_options("proxy")

# Sybol table
head(curl_symbols)
# Curl/ssl version info
curl_version()
}
\keyword{datasets}
