% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-migrate.R
\name{unfold}
\alias{unfold}
\title{Move spatial variables into the long form}
\usage{
unfold(data, ...)
}
\arguments{
\item{data}{a long cubble object}

\item{...}{spatial variables to move into the long form}
}
\value{
a cubble object in the long form
}
\description{
Some spatio-temporal transformation, i.e. glyph maps, uses both spatial
and temporal variables. \code{unfold()} allows you to temporarily moves spatial
variables into the long form for these transformations.
}
\examples{
cb <- climate_flat |>
  as_cubble(key = id, index = date, coords = c(long, lat)) |>
  face_temporal()

# unfold long and lat
cb_mig <- cb |> unfold(long, lat)

# unfold is not memorised by cubble:
# if you switch to the nested cubble and then switch back,
# long and lat will not be preserved
cb_mig |> face_spatial() |> face_temporal()

}
