% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window.R
\name{slide_codon}
\alias{slide_codon}
\title{sliding window of codons}
\usage{
slide_codon(seq, step = 1, before = 0, after = 0)
}
\arguments{
\item{seq}{DNAString, the sequence}

\item{step}{integer, the step size}

\item{before}{integer, the number of codons before the center of a window}

\item{after}{integer, the number of codons after the center of a window}
}
\value{
data.table with start, center, and end columns
}
\description{
\code{slide_codon} generates a data.table with start, center, and end columns
  for a sliding window analysis of codons.
}
\examples{
x <- Biostrings::DNAString('ATCTACATAGCTACGTAGCTCGATGCTAGCATGCATCGTACGATCGTCGATCGTAG')
slide_codon(x, step = 3, before = 1, after = 1)

}
