% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-utf8.R
\name{write_raw}
\alias{write_raw}
\title{Write raw bytes}
\usage{
write_raw(con, x, bounds_check = NULL)
}
\arguments{
\item{con}{Connection object or raw vector. When con is a raw vector, new
data will be \emph{appended} to the vector and returned.
Connection objects can be 
created with \code{file()}, \code{url()}, 
\code{rawConnection()} or any of the other many connection creation
functions.}

\item{x}{vector to write}

\item{bounds_check}{Check values lie within bounds of the given type.
Default: NULL indicates that
this option should be retrieved from the connection object if possible
(where the user has used \code{\link{set_bounds_check}()}) or otherwise 
will be set to \code{"error"}}
}
\value{
If \code{con} is a connection then this connection is returned invisibly.
        If \code{con} is a raw vector then new data is appended to this vector
}
\description{
Write raw bytes
}
\examples{
con <- file(tempfile(), "wb")
write_raw(con, as.raw(1:4))
write_raw(con, 1:4) 
close(con)
}
\seealso{
Other data output functions: 
\code{\link{fprintf}()},
\code{\link{write_f64}()},
\code{\link{write_hex}()},
\code{\link{write_uint8}()},
\code{\link{write_utf8}()}
}
\concept{data output functions}
