% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-hex.R
\name{write_hex}
\alias{write_hex}
\title{Write hexadecimal string as raw bytes}
\usage{
write_hex(con, x, endian = NULL)
}
\arguments{
\item{con}{Connection object or raw vector. When con is a raw vector, new
data will be \emph{appended} to the vector and returned.
Connection objects can be 
created with \code{file()}, \code{url()}, 
\code{rawConnection()} or any of the other many connection creation
functions.}

\item{x}{vector to write}

\item{endian}{Ordering of bytes within the file when reading multi-byte values.
Possible values: 'big' or 'little'.  
Default: NULL indicates that
endian option should be retrieved from the connection object if possible
(where the user has used \code{\link{set_endian}()}) or otherwise 
will be set to \code{"little"}}
}
\value{
If \code{con} is a connection then this connection is returned invisibly.
        If \code{con} is a raw vector then new data is appended to this vector
}
\description{
Write hexadecimal string as raw bytes
}
\examples{
con <- file(tempfile(), "wb")
write_hex(con, c("ff80", "0102"))
close(con)
}
\seealso{
Other data output functions: 
\code{\link{fprintf}()},
\code{\link{write_f64}()},
\code{\link{write_raw}()},
\code{\link{write_uint8}()},
\code{\link{write_utf8}()}
}
\concept{data output functions}
