% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cramer.R
\encoding{UTF-8}
\name{plot_cramer}
\alias{plot_cramer}
\title{Constructs a serial dependence plot based on Cramer's vi}
\usage{
plot_cramer(
  series,
  max_lag = 10,
  alpha = 0.05,
  plot = TRUE,
  title = "Serial dependence plot",
  bar_width = 0.12,
  ...
)
}
\arguments{
\item{series}{An object of type \code{tsibble} (see R package \code{tsibble}), whose column named Value
contains the values of the corresponding CTS. This column must be of class \code{factor} and its levels
must be determined by the range of the CTS.}

\item{max_lag}{The maximum lag represented in the plot (default is 10).}

\item{alpha}{The significance level for the corresponding hypothesis test (default is 0.05).}

\item{plot}{Logical. If \code{plot = TRUE} (default), returns the serial dependence
plot. Otherwise, returns a list with the values of Cramer's vi, the critical
value and the corresponding p-values.}

\item{title}{The title of the graph.}

\item{bar_width}{The width of the corresponding bars.}

\item{...}{Additional parameters for the function.}
}
\value{
If \code{plot = TRUE} (default), returns the serial dependence plot based on Cramer's vi. Otherwise, the function
returns a list with the values of Cramer's vi, the critical
value and the corresponding p-values.
}
\description{
\code{plot_cramer} constructs a serial dependence plot of a categorical
time series based on Cramer's vi
}
\details{
Constructs a serial dependence plot based on Cramer's vi, \eqn{\widehat{v}(l)},
for several lags. A dashed lined is incorporated indicating the critical value
of the test based on the following asymptotic approximation (under the i.i.d. assumption):
\deqn{T(r-1)\widehat{v}(l)^2 \sim\chi^2_{(r-1)^2},} where \eqn{T} is the series length
and \eqn{r} is the number of categories in the time series.
}
\examples{
sequence_1 <- SyntheticData1[which(SyntheticData1$Series==1),]
plot_cv <- plot_cramer(series = sequence_1, max_lag = 3) # Representing
# the serial dependence plot
list_cv <- plot_cramer(series = sequence_1, max_lag = 3, plot = FALSE) # Obtaining
# the values of Cramer's vi, the critical value and the p-values
}
\references{
{

  \insertRef{weiss2013serial}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
