% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctCheckFit.R
\name{ctCheckFit}
\alias{ctCheckFit}
\title{Check absolute fit of ctFit or ctStanFit object.}
\usage{
ctCheckFit(fit, niter = 500, probs = c(0.025, 0.5, 0.975))
}
\arguments{
\item{fit}{ctsem fit object.}

\item{niter}{number of data generation iterations to use to calculate quantiles.}

\item{probs}{3 digit vector of quantiles to return and to test significance.}
}
\value{
List containing a means and cov object, computed by sorting data into discrete time points.
cov is a numeric matrix containing measures of the covariance matrices for observed and simulated data. 
The MisspecRatio column shows Z score difference for each lower triangular index of the covariance matrix of data --
observed covariance minus mean of generated, weighted by sd of generated covariance.
means contains the empirical and generated data means.
}
\description{
Check absolute fit of ctFit or ctStanFit object.
}
\details{
for plotting help see \code{\link{plot.ctsemFitMeasure}}
}
\examples{
\donttest{
scheck <- ctCheckFit(ctstantestfit,niter=50)
}
}
