% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctStanParMatrices.R
\name{ctStanParMatrices}
\alias{ctStanParMatrices}
\title{Returns model equation and other matrices from a ctStanFit object, and vector of values for free parameters.}
\usage{
ctStanParMatrices(fit, parvalues, timeinterval = 1, sf = NA)
}
\arguments{
\item{fit}{ctStanFit object.}

\item{parvalues}{vector of parameter values to assign to free parameters in the model}

\item{timeinterval}{time interval to use for discrete time (dt) matrix calculations.}

\item{sf}{stanfit object. Generally not necessary, but for repeated calls to this function, can speed things up.}
}
\value{
A list containing various matrices related to a continuous time dynamic model. 
Matrices with "dt" in front refers to discrete time, "asym" refers to asymptotic (time interval = infinity), 
and "cor" refers to correlations.
}
\description{
Returns model equation and other matrices from a ctStanFit object, and vector of values for free parameters.
}
\examples{
\dontrun{
ctStanParMatrices(ctstantestfit,rnorm(17,0,.1))
}
}
