% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mutation_read_names.R
\name{get_mutation_read_names}
\alias{get_mutation_read_names}
\title{Gets names of the reads showing reference and alternative alleles of a mutation}
\usage{
get_mutation_read_names(bam, chr, pos, ref, alt, tag = "",
  min_base_quality = 20, min_mapq = 30)
}
\arguments{
\item{bam}{path to bam file.}

\item{chr}{Chromosome name for the mutation.}

\item{pos}{Chromosome position for the mutation.}

\item{ref}{The reference allele of the mutation.}

\item{alt}{The alternative allele of the mutation.}

\item{tag}{the RG tag if the bam has more than one sample.}

\item{min_base_quality}{integer specifying the minimum base quality for reads to be included.}

\item{min_mapq}{integer specifying the minimum mapping quality for reads to be included.}
}
\value{
A character vector having the read names
}
\description{
Extract the names of the reads in a bam file that support the variant allele of a single mutation
}
\keyword{internal}
