% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/csrplus.R
\name{mwin}
\alias{mwin}
\title{Moving Window Approach to Quadrat Counts}
\source{
Cressie, Noel. "Chapter 8: Spatial Point Patterns." Statistics for Spatial Data. Revised ed. New York: John Wiley and Sons, 1993. N. pag. Print.

Gatrell, Anthony C. "Chapter 3: Introductory Methods for Point Patterns." Interactive Spatial Data Analysis. By Trevor C. Bailey. N.p.: Routledge, 1995. N. pag. Print.
}
\usage{
mwin(xcoord, ycoord, boundaryx, boundaryy, gridx, gridy, windowsizel, windowsizew)
}
\arguments{
\item{xcoord}{a vector containing the x-coordinates of the observed point process}

\item{ycoord}{a vector containing the y-coordinates of the observed point process}

\item{boundaryx}{a vector containing the x-coordinates of the boundary}

\item{boundaryy}{a vector containing the y-coordinates of the boundary}

\item{gridx}{integer for the number of column lattice points}

\item{gridy}{integer for the number of row lattice points}

\item{windowsizel}{integer for the length of the window}

\item{windowsizew}{integer for the width of the window}
}
\value{
xgrid a vector of the x-coordinates of the lattice points within the boundary

ygrid a vector of the y-coordinates of the lattice points within the boundary

quadrat a vector containing the number of events within each window sampled along the lattice
}
\description{
Calculates quadrat counts to estimate the intensity of a spatial point process through the moving window approach proposed by Bailey and Gatrell (1995).
Event counts are computed within a window of a set size over a fine lattice of points within the region of observation.
}
\details{
The function first constructs a rectangular space based on the maximum and minimum values of the boundary.
It then places a lattice over the rectangle, with a number of points in the lattice defined by the user.
The "point.in.polygon" function determines whether or not a specific lattice point falls within the region of observation.
If so, the function counts the number of events in a window of a specified size centered on that point.  If not, the function moves on to the next lattice point.
The function returns the location of lattice points within the region of observation in addition to the quadrat count at each point.
}
\examples{
# To load data corresponding to the location of earthquakes in California:
data(quake)

# To load data corresponding to the boundary:
data(boundary)

# To compute quadrat counts with a 40 x 40 lattice and 1 x 1 unit window:
m <- mwin(quake[,3], quake[,2], boundary[,1], boundary[,2], 40, 40, 1, 1)

# To plot the results (with the shading corresponding to the quadrat count):
layout(matrix(c(1,2), nc=2), widths = c(4, 1))
palette(rev(heat.colors((max(as.numeric(m$quadrat))-min(as.numeric(m$quadrat))))))
plot(m$xgrid, m$ygrid, col=m$quadrat, pch=15, cex=.8,
     xlab="X-Coordinates", ylab="Y Coordinates", main="Quadrat Count")
lines(boundary[,1], boundary[,2])
breaks <- seq(min(as.numeric(m$quadrat)), (max(as.numeric(m$quadrat))), by=1)
plot.new()
plot.window(xlim = c(0, 1),ylim = range(breaks),xaxs = "i", yaxs = "i")
rect(0, breaks[-length(breaks)],1, breaks[-1],
col = rev(heat.colors(length(breaks) - 1)))
axis(2)
}

