% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranks_multinom.R
\name{csranks_multinom}
\alias{csranks_multinom}
\title{Confidence sets for ranks based on multinomial data}
\usage{
csranks_multinom(
  x,
  coverage = 0.95,
  cstype = "two-sided",
  simul = TRUE,
  multcorr = "Holm",
  indices = NA,
  na.rm = FALSE
)
}
\arguments{
\item{x}{vector of counts indicating how often each category was chosen.}

\item{coverage}{nominal coverage of the confidence set. Default is 0.95.}

\item{cstype}{type of confidence set (\code{two-sided}, \code{upper}, \code{lower}). Default is \code{two-sided}.}

\item{simul}{logical; if \code{TRUE} (default), then simultaneous confidence sets are computed, which jointly cover all populations indicated by \code{indices}.
Otherwise, for each population indicated in \code{indices} a marginal confidence set is computed.}

\item{multcorr}{multiplicity correction to be used: \code{Holm} (default) or \code{Bonferroni}. See Details section for more.}

\item{indices}{vector of indices of \code{x} for whose ranks the confidence sets are computed. \code{indices=NA} (default) means computation of confidence sets for all populations.}

\item{na.rm}{logical; if \code{TRUE}, then \code{NA}'s are removed from \code{x} and \code{Sigma} (if any).}
}
\value{
A \code{csranks} object, which is a list with three items:
\describe{
\item{\code{L}}{Lower bounds of the confidence sets for ranks indicated in \code{indices}}
\item{\code{rank}}{Estimated ranks from \code{\link{irank}} with default parameters}
\item{\code{U}}{Upper bounds of the confidence sets.}
}
}
\description{
Marginal and simultaneous confidence sets for ranks of categories, where categories are ranked by the probabilities of being chosen.
}
\section{Details}{

This function computes confidence sets for ranks similarly as \code{\link{csranks}}, but it is tailored to the special case of
multinomial data. Suppose there are \eqn{p} populations (for the case of multinomial data, we will refer to them as "categories") such
as political parties, for example, that one wants to rank by the probabilities of them being chosen. For political parties, this would
correspond to the share of votes each party obtains. Here, the underlying data are multinomial: each observation corresponds to a choice
among the \eqn{p} categories. The vector \code{x} contains the counts of how often each category was chosen in the data.

In this setting, \code{link{csranks}} could be applied to compute confidence sets for the ranks of each category, but instead this function
implements a different method proposed by Bazylik, Mogstad, Romano, Shaikh, and Wilhelm (2023), which exploits the
multinomial structure of the problem and yields confidence sets for the ranks that are valid in finite samples (whereas \code{\link{csranks}} produces
confidence sets that are valid only asymptotically).

The procedure involves testing multiple hypotheses. The \verb{\code{multcorr}} indicates a method for multiplicity correction. See the paper for
details.
}

\examples{
x <- c(rmultinom(1, 1000, 1:10))
csranks_multinom(x)
}
\references{
Bazylik, Mogstad, Romano, Shaikh, and Wilhelm.
"Finite-and large-sample inference for ranks using multinomial data with an application to ranking political parties".
\href{http://dwilhelm.userweb.mwn.de/papers/cwp4021.pdf}{cemmap working paper}
}
