% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_network_data.R
\name{get_network_data}
\alias{get_network_data}
\title{Get state networks data}
\usage{
get_network_data(category = NULL, merge_data = NULL)
}
\arguments{
\item{category}{A category within the networks data. Default is NULL. If left
blank, returns the full state networks data. Category options are "Distance
Travel Migration", "Economic", "Political", "Policy", "Demographic".}

\item{merge_data}{Default is NULL. Takes a dataframe object in the format
generated by \code{\link{get_cspp_data}}. The function merges this
dataframe into the network data by state. If the merge dataframe has multiple
observations per state, this function averages over all values per state as
long as the variables are numeric. If the dataframe passed has multiple
values per state and some are not numeric, only numeric variables are merged.}
}
\value{
A dataframe formatted as an edge list.
}
\description{
\code{network_data} returns a dataframe of the state networks data compiled
by the Correlates of State Policy Project. The dataframe is in an edge list
format, with each row a state dyad combination. The \code{merge} argument
allows the direct merging of a dataframe generated by the
\code{\link{get_cspp_data}} function.
}
\details{
The network dataframe that results is directed, with variables directed
towards the state in the \code{State1} column. For instance, the
\code{IncomingFlights} variable is the number of flights from \code{State2}
with a destination in \code{State1}.
}
\examples{

# Load full network data:
network.df <- get_network_data()

# Network data for subset of categories:
network.df <- get_network_data(category = c("Economic", "Political"))

# Merge in data from get_cspp_data()
network.df <- get_network_data(category = "Distance Travel Migration",
                               merge_data  = get_cspp_data(vars = c("sess_length", "hou_majority"),
                                                           years = seq(1999, 2000)))

}
\seealso{
For more information on the construction of the network data as well
  as a full codebook see
  \url{http://ippsr.msu.edu/public-policy/state-networks}.
}
