/*
 * Decompiled with CFR 0.152.
 */
package org.libtiff.jai.codecimpl;

import java.awt.Rectangle;
import org.libtiff.jai.codec.XTIFFTileCodec;
import org.libtiff.jai.codec.XTIFFTileCodecImpl;

public class XTIFFUncompTileCodec
extends XTIFFTileCodecImpl {
    public XTIFFTileCodec create() {
        return new XTIFFUncompTileCodec();
    }

    public boolean canEncode() {
        return true;
    }

    public void register() {
        this.register(1);
    }

    public int encodeTilePixels(int[] pixels, Rectangle rect, byte[] bpixels) {
        int rows = (int)rect.getHeight();
        int cols = (int)rect.getWidth();
        int pixel = 0;
        int k = 0;
        int rowBytes = 0;
        switch (this.sampleSize[0]) {
            case 1: {
                int index = 0;
                rowBytes = (cols + 7) / 8;
                for (int i = 0; i < rows; ++i) {
                    int j;
                    for (j = 0; j < cols / 8; ++j) {
                        pixel = pixels[index++] << 7 | pixels[index++] << 6 | pixels[index++] << 5 | pixels[index++] << 4 | pixels[index++] << 3 | pixels[index++] << 2 | pixels[index++] << 1 | pixels[index++];
                        bpixels[k++] = (byte)pixel;
                    }
                    if (cols % 8 <= 0) continue;
                    pixel = 0;
                    for (j = 0; j < cols % 8; ++j) {
                        pixel |= pixels[index++] << 7 - j;
                    }
                    bpixels[k++] = (byte)pixel;
                }
                break;
            }
            case 4: {
                int index = 0;
                rowBytes = (cols + 3) / 4;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols / 2; ++j) {
                        pixel = pixels[index++] << 4 | pixels[index++];
                        bpixels[k++] = (byte)pixel;
                    }
                    if (cols % 2 != 1) continue;
                    pixel = pixels[index++] << 4;
                    bpixels[k++] = (byte)pixel;
                }
                break;
            }
            case 8: {
                int index = 0;
                rowBytes = cols * this.numBands;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols * this.numBands; ++j) {
                        bpixels[k++] = (byte)pixels[index++];
                    }
                }
                break;
            }
            case 16: {
                int index = 0;
                rowBytes = cols * 2;
                int l = 0;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        short value = (short)pixels[index++];
                        bpixels[l++] = (byte)((value & 0xFF00) >> 8);
                        bpixels[l++] = (byte)(value & 0xFF);
                    }
                }
                break;
            }
        }
        return rows * rowBytes;
    }

    public void decodeTilePixels(byte[] input, Rectangle rect, byte[] bpixels) {
        for (int i = 0; i < this.unitsInThisTile; ++i) {
            bpixels[i] = input[i];
        }
    }

    public void decodeTilePixels(byte[] input, Rectangle rect, short[] spixels) {
        this.unpackShorts(input, spixels, this.unitsInThisTile);
    }
}

