% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFNG.R
\name{getFGIndex}
\alias{getFGIndex}
\title{Get the daily Fear and Greed Index
for the cryptocurrency market}
\usage{
getFGIndex(from = NULL, to = NULL)
}
\arguments{
\item{from}{An optional vector of length 1. Can be \code{\link[=Sys.Date]{Sys.Date()}}-class, \code{\link[=Sys.time]{Sys.time()}}-class or \code{\link[=as.character]{as.character()}} in \%Y-\%m-\%d format.}

\item{to}{An optional vector of length 1. Can be \code{\link[=Sys.Date]{Sys.Date()}}-class, \code{\link[=Sys.time]{Sys.time()}}-class or \code{\link[=as.character]{as.character()}} in \%Y-\%m-\%d format.}
}
\value{
A xts object with the FGI daily score
}
\description{
The fear and greed index is a market sentiment indicator that measures investor emotions to
gauge whether they are generally fearful (indicating potential selling pressure) or greedy (indicating potential buying enthusiasm)
}
\details{
The Fear and Greed Index goes from 0-100, and can be classifed as follows

\itemize{
\item 0-24, Extreme Fear
\item 25-44, Fear
\item 45-55, Neutral
\item 56-75, Greed
\item 76-100, Extreme Greed
}
}
\examples{
# script: Fear and Greed Index
# date: 2023-12-26
# author: Serkan Korkmaz, serkor1@duck.com
# objective: Retrieve and Plot the
# index
# script start;

# 1) get the fear and greed index
# over time
FGI <- try(
  cryptoQuotes::getFGIndex()
)

# 2) get BTCUSDT-pair on
# daily
BTCUSDT <- try(
  cryptoQuotes::getQuote(
    ticker = 'BTCUSDT',
    interval = '1d',
    futures = FALSE
  )
)

# 3) chart the klines
# of BTCUSDT with
# the Fear and Greed Index
if (!inherits(BTCUSDT, 'try-error') & !inherits(FGI, 'try-error')) {

  cryptoQuotes::chart(
    chart = cryptoQuotes::kline(
      BTCUSDT
    ) \%>\% cryptoQuotes::addFGIndex(
      FGI = FGI
    ),
    slider = FALSE
  )

}

# script end;
}
\seealso{
Other sentiment: 
\code{\link{getLSRatio}()}
}
\concept{sentiment}
