% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart_indicators.R
\name{addVolume}
\alias{addVolume}
\title{Add volume indicators
to the chart}
\usage{
addVolume(chart)
}
\arguments{
\item{chart}{a \code{\link[=kline]{kline()}} or \code{\link[=ohlc]{ohlc()}} chart}
}
\value{
Invisbly returns a plotly object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Volume indicators are technical analysis tools used to analyze trading volume, which represents the number of shares or contracts traded in a financial market over a specific period of time.
These indicators provide valuable insights into the strength and significance of price movements.
}
\examples{
# script: scr_charting
# date: 2023-10-25
# author: Serkan Korkmaz, serkor1@duck.com
# objective: Charting in general
# script start;

# library
library(cryptoQuotes)

# charting klines
# with various indicators
chart(
  chart = kline(
    ATOMUSDT
  ) \%>\% addVolume() \%>\% addMA(
    FUN = TTR::SMA,
    n = 7
  ) \%>\% addMA(
    FUN = TTR::SMA,
    n = 14
  ) \%>\%
    addBBands() \%>\%
    addMACD() \%>\%
    addRSI()

)


# script end;
}
\seealso{
Other chart indicators: 
\code{\link{addBBands}()},
\code{\link{addEvents}()},
\code{\link{addFGIndex}()},
\code{\link{addLSRatio}()},
\code{\link{addMACD}()},
\code{\link{addMA}()},
\code{\link{addRSI}()},
\code{\link{chart}()}
}
\concept{chart indicators}
