% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reflections.R
\name{writeMTZ}
\alias{writeMTZ}
\title{Write data to an MTZ file}
\usage{
writeMTZ(reflections, header, filename, title = NULL, batch_header = NULL)
}
\arguments{
\item{reflections}{A data frame containing all reflection
records in columns. This is usually derived
from modifications of a previously existing
data frame obtained using
\code{\link{readMTZ}}.}

\item{header}{A list whose components are other R objects. This
is normally derived from the reading of another
MTZ file using \code{\link{readMTZ}}. See further
details at \code{\link{readMTZHeader}}.}

\item{filename}{A character string. The path to a valid mtz
file. If a file with the same name exists, it
will be deleted.}

\item{title}{A character string. The character string
associated with the TITLE keyword in an MTZ file.
This feature makes it easy to quickly identify the
data file in \href{https://www.ccp4.ac.uk}{CCP4}
programs. Default (NULL) is for the output file
to have the same title as the input file.}

\item{batch_header}{A named list including information at data
collection time. This component is present
only for raw (unmerged) intensity data
produce after the diffraction images
integration. Merged MTZ reflection files
have \code{batch_header=NULL}.
Names and types depend on
the type of experiment (more information
on this can be found at
\href{https://www.ccp4.ac.uk}{CCP4}.)}
}
\value{
This function does not return any R object. It outputs
        an MTZ reflection file to some target location.
}
\description{
Write reflections and experimental information
to an MTZ file
}
\examples{
# Read the 1dei_phases data included in the package
datadir <- system.file("extdata",package="cry")
filename <- file.path(datadir,"1dei_phases.mtz")
lMTZ <- readMTZ(filename)

# Change dataset name
print(lMTZ$header$DATASET)
lMTZ$header$DATASET[2,2] <- "New CRY dataset"

# Add one HISTORY line (string has to be 80-letters long)
addhist <- "From CRY 0.3.0 - run on Apr 2 20:12:00 2021"
n <- nchar(addhist)
nblanks <- 80-n
for (i in 1:nblanks) addhist <- paste0(addhist," ")
lMTZ$header$HISTORY <- c(lMTZ$header$HISTORY,addhist)

# Write to a new MTZ file
wd <- tempdir()
fname <- file.path(wd,"new.mtz")
writeMTZ(lMTZ$reflections,lMTZ$header,fname)

}
