% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\docType{data}
\name{HttpClient}
\alias{HttpClient}
\title{HTTP client}
\arguments{
\item{url}{(character) A url. One of \code{url} or \code{handle} required.}

\item{opts}{(list) curl options}

\item{handle}{A handle}
}
\description{
HTTP client
}
\details{
\strong{Methods}
  \describe{
    \item{\code{get(path, query, disk, stream, ...)}}{
      Make a GET request
    }
    \item{\code{post(path, query, body, disk, stream, ...)}}{
      Make a POST request
    }
    \item{\code{put(path, query, body, disk, stream, ...)}}{
      Make a PUT request
    }
    \item{\code{patch(path, query, body, disk, stream, ...)}}{
      Make a PATCH request
    }
    \item{\code{delete(path, query, body, disk, stream, ...)}}{
      Make a DELETE request
    }
    \item{\code{head(path, disk, stream, ...)}}{
      Make a HEAD request
    }
  }

Possible parameters (not all are allowed in each HTTP verb):
\itemize{
 \item path - URL path, appended to the base URL
 \item query - query terms, as a list
 \item body - body as an R list
 \item disk - a path to write to. if NULL (default), memory used
 \item stream - an R function to determine how to stream data. if
 NULL (default), memory used
 \item ... curl options, only those in the acceptable set from
 \code{\link[curl]{curl_options}} except the following: httpget, httppost,
 post, postfields, postfieldsize, and customrequest
}
}
\examples{
(x <- HttpClient$new(url = "https://httpbin.org"))
x$url
(res_get1 <- x$get('get'))
res_get1$content
res_get1$response_headers
res_get1$parse()

(res_get2 <- x$get('get', query = list(hello = "world")))
res_get2$parse()
library("jsonlite")
jsonlite::fromJSON(res_get2$parse())

# post request
(res_post <- x$post('post', body = list(hello = "world")))

## empty body request
x$post('post')

# put request
(res_put <- x$put('put'))

# delete request
(res_delete <- x$delete('delete'))

# patch request
(res_patch <- x$patch('patch'))

# head request
(res_head <- x$head())

# set curl options on client initialization
(res <- HttpClient$new(
  url = "https://httpbin.org",
  opts = list(
    verbose = TRUE,
    useragent = "hello world"
  )
))
res$opts
res$get('get')

# or set curl options when performing HTTP operation
(res <- HttpClient$new(url = "https://httpbin.org"))
res$get('get', verbose = TRUE)
\dontrun{res$get('get', stuff = "things")}
\dontrun{res$get('get', httpget = TRUE)}


# set headers
(res <- HttpClient$new(
  url = "https://httpbin.org",
  opts = list(
    verbose = TRUE
  ),
  headers = list(
    a = "stuff",
    b = "things"
  )
))
res$headers
# reassign header value
res$headers$a <- "that"
# define new header
res$headers$c <- "what"
# request
res$get('get')


# handles - pass in your own handle
h <- handle("https://httpbin.org")
(res <- HttpClient$new(handle = h))
out <- res$get("get")

# write to disk
(x <- HttpClient$new(url = "https://httpbin.org"))
f <- tempfile()
res <- x$get(disk = f)
res$content # when using write to disk, content is a path
readLines(res$content)

# streaming response
(x <- HttpClient$new(url = "https://httpbin.org"))
res <- x$get('stream/50', stream = function(x) cat(rawToChar(x)))
res$content # when streaming, content is NULL
}
\keyword{datasets}

