% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration_ppt_etp.R
\name{eto_calibration}
\alias{eto_calibration}
\title{Calibration of reference evapotranspiration (eto) of 'TerraClimate'}
\usage{
eto_calibration(slope, intercept, etp_stack)
}
\arguments{
\item{slope}{the slope of the linear regression (numeric).}

\item{intercept}{the intercept of the linear regression (numeric).}

\item{etp_stack}{stack of eto.}
}
\value{
Returns a Rasterstack of eto calibrated.
}
\description{
This function will calibrate the reference evapotranspiration (eto) from TerraClimate dataset based in the relationship with observed weather stations data.
}
\examples{
\dontrun{
etp_cal<- eto_calibration(slope = 0.930073,
                           intercept = 22.399986, etp_stack = etp);
}
}
