% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_jags.R
\name{h_jags_write_model}
\alias{h_jags_write_model}
\title{Writing JAGS Model to a File}
\usage{
h_jags_write_model(model, file = NULL, digits = 5)
}
\arguments{
\item{model}{(\code{function})\cr function containing the JAGS model.}

\item{file}{(\code{string} or \code{NULL})\cr the name of the file (including the
optional path) where the model will be saved. If \code{NULL}, the file will be
created in a \code{R_crmPack} folder placed under temporary directory indicated
by \code{\link[=tempdir]{tempdir()}} function.}

\item{digits}{(\code{count})\cr a desired number of significant digits for
for numbers used in JAGS input, see \code{\link[=formatC]{formatC()}}.}
}
\value{
The name of the file where the model was saved.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This function converts a R function with JAGS model into a text and then
writes it into a given file. During the "model into text" conversion, the
format of numbers of which absolute value is less than \code{0.001} or greater
than \code{10000} is changed. These numbers will be converted into scientific
format with specified number of significant digits using \code{\link[=formatC]{formatC()}}
function.
}
\note{
JAGS syntax allows truncation specification like \verb{dnorm(...) I(...)},
which is illegal in R. To overcome this incompatibility, use dummy operator
\verb{\\\%_\\\%} before \code{I(...)}, i.e. \verb{dnorm(...) \\\%_\\\% I(...)} in the model's
code. This dummy operator \verb{\\\%_\\\%} will be removed just before saving the
JAGS code into a file.
Due to technical issues related to conversion of numbers to scientific
format, it is required that the body of a model function does not contain
\code{TEMP_NUM_PREF_} or \verb{_TEMP_NUM_SUF} character constants in its body.
}
\examples{
# Some model function
my_model <- function() {
  alpha0 <- mean(1:10)
  alpha1 <- 600000
}

h_jags_write_model(my_model, digits = 5)
}
