% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers_model.R
\name{h_model_dual_endpoint_beta}
\alias{h_model_dual_endpoint_beta}
\title{Update certain components of \code{\link{DualEndpoint}} model with regard to parameters
of the function that models dose-biomarker relationship defined in the
\code{\link{DualEndpointBeta}} class.}
\usage{
h_model_dual_endpoint_beta(
  param,
  param_name,
  param_suffix = c("_low", "_high"),
  priormodel = NULL,
  de
)
}
\arguments{
\item{param}{(\code{numeric})\cr the value of a given \code{param_name} parameter of
the dose-biomarker relationship function \eqn{f(x)}. Either a fixed-valued
scalar or vector with two elements that are the parameters of a probability
distribution that will be used in \code{priormodel} function to generate values
for the \code{param_name} parameter of \eqn{f(x)}.}

\item{param_name}{(\code{string})\cr the name of the parameter of \eqn{f(x)},
whose value depends on \code{param}.}

\item{param_suffix}{(\code{character})\cr the two suffixes to be appended to
the elements of \code{param_name} and then used when updating \code{modelspecs}.
The value of this argument is ignored when \code{param} is a scalar.}

\item{priormodel}{(\code{function} or \code{NULL})\cr a function representing the
\code{JAGS} prior specification that will be appended to existing
\code{de@priormodel} specification if \code{param} is not a scalar. Otherwise,
\code{de@priormodel} remains unchanged.}

\item{de}{(\code{DualEnpoint})\cr dual endpoint model whose slots will be updated.}
}
\value{
A \code{\link{DualEndpoint}} model with updated \code{use_fixed}, \code{priormodel},
\code{modelspecs}, \code{init}, \code{sample} slots.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A simple helper function that takes \code{\link{DualEndpoint}} object and updates
\code{use_fixed}, \code{priormodel}, \code{modelspecs}, \code{init}, \code{sample} slots with regard
to a given parameter of the dose-biomarker relationship \eqn{f(x)} defined in
the \code{\link{DualEndpointBeta}} class. This update solely depends on whether a given
parameter's value \code{param} is a fixed-valued scalar or two-elements numeric
vector. In the later case, it is assumed that \code{param} represents two
parameters of a probability distribution that will be used in \code{priormodel}
function to generate values for the \code{param_name} parameter of \eqn{f(x)}.
See the help page for \code{\link{DualEndpointBeta}} class for more details.
}
