% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Samples-class.R
\docType{class}
\name{Samples-class}
\alias{.Samples}
\alias{Samples-class}
\title{Class for the MCMC output}
\description{
Class for the MCMC output
}
\section{Slots}{

\describe{
\item{\code{data}}{a list where each entry contains the samples of a (vector-valued)
parameter in a vector/matrix in the format (number of samples) x (dimension
of the parameter).}

\item{\code{options}}{the \code{\linkS4class{McmcOptions}} which have been used}
}}
\examples{

# Saving the mcmc options which were used to generate the samples
options <- McmcOptions(burnin=10000,
                       step=2,
                       samples=10000)

# Create an object of class 'Samples'
# Here the parameters 'alpha' and 'beta' are randomly generated. Of coure in 
# a real example these would come as an output from mcmc procedures
samples <- Samples(data=list(alpha=rnorm(10000),beta=rnorm(10000)),
                   options=options)

}
\keyword{classes}

