% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_cricinfo.R
\name{fetch_cricinfo}
\alias{fetch_cricinfo}
\title{Fetch Data from Cricinfo}
\usage{
fetch_cricinfo(
  matchtype = c("test", "odi", "t20"),
  sex = c("men", "women"),
  activity = c("batting", "bowling", "fielding"),
  type = c("career", "innings"),
  country = NULL
)
}
\arguments{
\item{matchtype}{Character indicating test (default), odi, or t20.}

\item{sex}{Character indicating men (default) or women.}

\item{activity}{Character indicating batting (default), bowling or fielding.}

\item{type}{Character indicating innings-by-innings or career (default) data}

\item{country}{Character indicating country. The default is to fetch data for all countries.}
}
\value{
A \code{tibble} object, similar to a \code{data.frame}.
}
\description{
Fetch data from ESPNCricinfo and return a tibble. 
All arguments are case-insensitive and partially matched.
}
\examples{
\dontrun{
auswt20 <- fetch_cricinfo("T20", "Women", country="Aust")
IndiaODIBowling <- fetch_cricinfo("ODI", "men", "bowling", country="india")
}

}
\author{
Rob J Hyndman, Timothy Hyndman, Charles Gray
}
