% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_launcher_local.R
\name{crew_class_launcher_local}
\alias{crew_class_launcher_local}
\title{Local process launcher class}
\description{
\code{R6} class to launch and manage local process workers.
}
\details{
See \code{\link[=crew_launcher_local]{crew_launcher_local()}}.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_session_start()
router <- crew_router()
router$start()
launcher <- crew_launcher_local()
launcher$populate(sockets = router$sockets)
launcher$launch()
m <- mirai::mirai("result", .compute = router$name)
Sys.sleep(0.25)
m$data
router$terminate()
crew_session_terminate()
}
}
\seealso{
Other launchers: 
\code{\link{crew_class_launcher}},
\code{\link{crew_launcher_local}()},
\code{\link{crew_launcher}()}
}
\concept{launchers}
\section{Super class}{
\code{\link[crew:crew_class_launcher]{crew::crew_class_launcher}} -> \code{crew_class_launcher_local}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_launcher_local-launch_worker}{\code{crew_class_launcher_local$launch_worker()}}
\item \href{#method-crew_class_launcher_local-terminate_worker}{\code{crew_class_launcher_local$terminate_worker()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="call"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-call'><code>crew::crew_class_launcher$call()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="expected"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-expected'><code>crew::crew_class_launcher$expected()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="initialize"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-initialize'><code>crew::crew_class_launcher$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="launch"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-launch'><code>crew::crew_class_launcher$launch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="launching"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-launching'><code>crew::crew_class_launcher$launching()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="settings"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-settings'><code>crew::crew_class_launcher$settings()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="start"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-start'><code>crew::crew_class_launcher$start()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="terminate"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-terminate'><code>crew::crew_class_launcher$terminate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="validate"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-validate'><code>crew::crew_class_launcher$validate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_local-launch_worker"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_local-launch_worker}{}}}
\subsection{Method \code{launch_worker()}}{
Launch a local process worker which will
dial into a socket.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_local$launch_worker(call, launcher, worker, instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{call}}{Text string with a namespaced call to \code{\link[=crew_worker]{crew_worker()}}
which will run in the worker and accept tasks.}

\item{\code{launcher}}{Character of length 1, name of the launcher.}

\item{\code{worker}}{Positive integer of length 1, index of the worker.
This worker index remains the same even when the current instance
of the worker exits and a new instance launches.
It is always between 1 and the maximum number of concurrent workers.}

\item{\code{instance}}{Character of length 1 to uniquely identify
the current instance of the worker.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The \code{call} argument is R code that will run to
initiate the worker. Together, the \code{launcher}, \code{worker},
and \code{instance} arguments are useful for
constructing informative job names.
}

\subsection{Returns}{
A handle object to allow the termination of the worker
later on.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_local-terminate_worker"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_local-terminate_worker}{}}}
\subsection{Method \code{terminate_worker()}}{
Terminate a local process worker.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_local$terminate_worker(handle)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handle}}{A process handle object previously
returned by \code{launch_worker()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
}
