% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_controller.R
\name{crew_class_controller}
\alias{crew_class_controller}
\title{Controller class}
\description{
\code{R6} class for controllers.
}
\details{
See \code{\link[=crew_controller]{crew_controller()}}.
}
\examples{
if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_session_start()
router <- crew_router()
launcher <- crew_launcher_callr()
controller <- crew_controller(router = router, launcher = launcher)
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()
controller$terminate()
crew_session_terminate()
}

## ------------------------------------------------
## Method `crew_class_controller$new`
## ------------------------------------------------

if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_session_start()
router <- crew_router()
launcher <- crew_launcher_callr()
controller <- crew_controller(router = router, launcher = launcher)
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()
controller$terminate()
crew_session_terminate()
}
}
\seealso{
Other controllers: 
\code{\link{crew_class_controller_group}},
\code{\link{crew_controller_callr}()},
\code{\link{crew_controller_group}()},
\code{\link{crew_controller}()}
}
\concept{controllers}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{router}}{Router object.}

\item{\code{launcher}}{Launcher object.}

\item{\code{auto_scale}}{Scaling method. See \code{\link[=crew_controller]{crew_controller()}}.}

\item{\code{queue}}{List of tasks in the queue.}

\item{\code{results}}{List of finished tasks}

\item{\code{log}}{Data frame task log of the workers.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_controller-new}{\code{crew_class_controller$new()}}
\item \href{#method-crew_class_controller-validate}{\code{crew_class_controller$validate()}}
\item \href{#method-crew_class_controller-start}{\code{crew_class_controller$start()}}
\item \href{#method-crew_class_controller-clean}{\code{crew_class_controller$clean()}}
\item \href{#method-crew_class_controller-launch}{\code{crew_class_controller$launch()}}
\item \href{#method-crew_class_controller-scale}{\code{crew_class_controller$scale()}}
\item \href{#method-crew_class_controller-collect}{\code{crew_class_controller$collect()}}
\item \href{#method-crew_class_controller-push}{\code{crew_class_controller$push()}}
\item \href{#method-crew_class_controller-pop}{\code{crew_class_controller$pop()}}
\item \href{#method-crew_class_controller-wait}{\code{crew_class_controller$wait()}}
\item \href{#method-crew_class_controller-summary}{\code{crew_class_controller$summary()}}
\item \href{#method-crew_class_controller-terminate}{\code{crew_class_controller$terminate()}}
\item \href{#method-crew_class_controller-clone}{\code{crew_class_controller$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-new}{}}}
\subsection{Method \code{new()}}{
\code{mirai} controller constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$new(router = NULL, launcher = NULL, auto_scale = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{router}}{Router object. See \code{\link[=crew_controller]{crew_controller()}}.}

\item{\code{launcher}}{Launcher object. See \code{\link[=crew_controller]{crew_controller()}}.}

\item{\code{auto_scale}}{Scaling method. See \code{\link[=crew_controller]{crew_controller()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An \code{R6} object with the controller object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (identical(Sys.getenv("CREW_EXAMPLES"), "true")) {
crew_session_start()
router <- crew_router()
launcher <- crew_launcher_callr()
controller <- crew_controller(router = router, launcher = launcher)
controller$start()
controller$push(name = "task", command = sqrt(4))
controller$wait()
controller$pop()
controller$terminate()
crew_session_terminate()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the router.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-start"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-start}{}}}
\subsection{Method \code{start()}}{
Start the controller if it is not already started.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$start(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Register the mirai client and register worker websockets
with the launcher.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-clean"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-clean}{}}}
\subsection{Method \code{clean()}}{
Force terminate workers whose startup time has elapsed
and are not connected to the \code{mirai} client.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$clean()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-launch"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-launch}{}}}
\subsection{Method \code{launch()}}{
Launch one or more workers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$launch(n = 1L, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of workers to try to launch. The actual
number launched is capped so that no more than "\code{workers}"
workers running at a given time, where "\code{workers}"
is an argument of \code{\link[=crew_controller]{crew_controller()}}. The
actual cap is the "\code{workers}" argument minus the number of connected
workers minus the number of starting workers. A "connected"
worker has an active websocket connection to the \code{mirai} client,
and "starting" means that the worker was launched at most
\code{seconds_start} seconds ago, where \code{seconds_start} is
also an argument of \code{\link[=crew_controller]{crew_controller()}}.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-scale"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-scale}{}}}
\subsection{Method \code{scale()}}{
Run auto-scaling.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$scale(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method is called during \code{push()}, and the method for
scaling up workers is governed by the \code{auto_scale}
argument of \code{\link[=crew_controller]{crew_controller()}}. It is not meant to be called
manually. If called manually, it is recommended to call \code{collect()}
first so \code{scale()} can accurately assess the demand.
For finer control of the number of workers launched,
call \code{launch()} on the controller with the exact desired
number of workers.
}

\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-collect"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-collect}{}}}
\subsection{Method \code{collect()}}{
Check for done tasks and move the results to
the results list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$collect(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly). Removes elements from the \code{queue}
list as applicable and moves them to the \code{results} list.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-push"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-push}{}}}
\subsection{Method \code{push()}}{
Push a task to the head of the task list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$push(
  command,
  data = list(),
  globals = list(),
  seed = sample.int(n = 1000000000L, size = 1L),
  garbage_collection = FALSE,
  packages = character(0),
  library = NULL,
  seconds_timeout = NULL,
  name = NULL,
  scale = TRUE,
  controller = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{command}}{Language object with R code to run.}

\item{\code{data}}{Named list of local data objects in the
evaluation environment.}

\item{\code{globals}}{Named list of objects to temporarily assign to the
global environment for the task. At the end of the task,
these values are reset to their previous values.}

\item{\code{seed}}{Integer of length 1 with the pseudo-random number generator
seed to temporarily set for the evaluation of the task.
At the end of the task, the seed is restored.}

\item{\code{garbage_collection}}{Logical, whether to run garbage collection
with \code{gc()} before running the task.}

\item{\code{packages}}{Character vector of packages to load for the task.}

\item{\code{library}}{Library path to load the packages. See the \code{lib.loc}
argument of \code{require()}.}

\item{\code{seconds_timeout}}{Optional task timeout passed to the \code{.timeout}
argument of \code{mirai::mirai()} (after converting to milliseconds).}

\item{\code{name}}{Optional name of the task. Replaced with a random name
if \code{NULL} or in conflict with an existing name in the task list.}

\item{\code{scale}}{Logical, whether to automatically scale workers to meet
demand. If \code{TRUE}, then \code{clean()} and \code{collect()} run first
so demand can be properly assessed before scaling and the number
of workers is not too high.}

\item{\code{controller}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-pop"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-pop}{}}}
\subsection{Method \code{pop()}}{
Pop a completed task from the results data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$pop(scale = TRUE, controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scale}}{Logical, whether to automatically scale workers to meet
demand. If \code{TRUE}, then \code{clean()} and \code{collect()} run first
so demand can be properly assessed before scaling and the number
of workers is not too high. Scaling up on \code{pop()} may be important
for transient or nearly transient workers that tend to drop off
quickly after doing little work.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
If not task is currently completed and collected, \code{pop()}
will attempt to auto-scale workers as needed and collect
any newly completed results.
}

\subsection{Returns}{
If there is a completed task available to collect, the return
value is a one-row data frame with the results, warnings, and errors.
Otherwise, if there are no results available to collect,
the return value is \code{NULL}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-wait"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-wait}{}}}
\subsection{Method \code{wait()}}{
Wait for tasks.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$wait(
  mode = "all",
  seconds_interval = 0.001,
  seconds_timeout = Inf,
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{If \code{mode} is \code{"all"},
then the method waits for all tasks to complete. If \code{mode} is
\code{"one"}, then it waits until a one task is complete.}

\item{\code{seconds_interval}}{Number of seconds to wait between polling
intervals waiting for tasks.}

\item{\code{seconds_timeout}}{Timeout length in seconds waiting for tasks.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The \code{wait()} method blocks the calling R session,
repeatedly auto-scales workers for tasks
that need them, and repeatedly collects results.
The function runs until it either times out or reaches
its stopping condition based on the \code{mode} argument.
}

\subsection{Returns}{
\code{NULL} (invisibly). Call \code{pop()} to get the result.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-summary"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-summary}{}}}
\subsection{Method \code{summary()}}{
Summarize the workers and tasks of the controller.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$summary(
  columns = tidyselect::everything(),
  controllers = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{columns}}{Tidyselect expression to select a subset of columns.
Examples include \code{columns = contains("worker")} and
\code{columns = starts_with("tasks")}.}

\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame of summary statistics on the workers and tasks.
It has one row per worker websocket and the following columns:
\itemize{
\item \code{controller}: name of the controller.
\item \code{worker_socket} full websocket address of the worker, including
the protocol, IP address, TCP port, and path.
To identify specific pieces of the websocket address,
call \code{nanonext::parse_url()}.
\item \code{worker_connected}: \code{TRUE} if a worker is currently connected
to the websocket, \code{FALSE} if not connected, or \code{NA}
if the status cannot be determined because the \code{mirai}
client is not running.
\item \code{worker_busy}: \code{TRUE} if a worker is currently busy running a
task, \code{FALSE} if not busy, or \code{NA}
if the status cannot be determined because the \code{mirai}
client is not running.
\item \code{worker_launches}: number of attempts to launch a worker
at the websocket since the controller started. If
the number of launch attempts gets much higher than
the number of popped tasks or worker instances, then this is a
sign that something is wrong with the workers or platform,
and it is recommended to quit the pipeline and troubleshoot.
\item \code{worker_instances}: number of different worker processes
that have connected to the websocket since the \code{start()}
of the controller object. For persistent workers that
always stay running, \code{worker_instances} will be no more than 1.
However, in the case of transient workers, e.g. \code{tasks_max = 1}
or a small value of \code{seconds_idle}, worker processes may
time out or exit when the task workload subsides. Then when the
task workload surges again, different workers may be launch
and connect to the available websockets, so \code{worker_instances}
could be greater than 1.
\item \code{tasks_assigned}: number of pushed tasks assigned to the
current worker process at the websocket. The counter resets
every time a new worker replaces the previous worker at the
websocket. So in the case of transient
workers, this number may be much smaller than the number of
popped tasks.
\item \code{tasks_complete}: number of pushed tasks completed by the
current worker process at the websocket. The counter resets
every time a new worker replaces the previous worker at the
websocket. So in the case of transient
workers, this number may be much smaller than the number of
popped tasks.
\item \code{popped_tasks}: number of tasks which were completed by
a worker at the websocket and then returned by calling
\code{pop()} on the controller object.
\item \code{popped_seconds}: total number of runtime and seconds of
all the tasks that ran on a worker connected to this websocket
and then were retrieved by calling \code{pop()} on the controller
object.
\item \code{popped_errors}: total number of tasks which ran on a worker
at the website, encountered an error in R, and then retrieved
with \code{pop()}.
\item \code{popped_warnings}: total number of tasks which ran on a worker
at the website, encountered one or more warnings in R,
and then retrieved with \code{pop()}. Note: \code{popped_warnings}
is actually the number of \emph{tasks}, not the number of warnings.
(A task could throw more than one warning.)
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-terminate}{}}}
\subsection{Method \code{terminate()}}{
Terminate the workers and the \code{mirai} client.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$terminate(controllers = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{controllers}}{Not used. Included to ensure the signature is
compatible with the analogous method of controller groups.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_controller-clone"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_controller-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_controller$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
