% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_eval.R
\name{crew_eval}
\alias{crew_eval}
\title{Evaluate an R command and return results as a monad.}
\usage{
crew_eval(
  command,
  data = list(),
  globals = list(),
  seed = sample.int(n = 1000000000L, size = 1L),
  garbage_collection = FALSE,
  packages = character(0),
  library = NULL
)
}
\arguments{
\item{command}{Language object with R code to run.}

\item{data}{Named list of local data objects in the evaluation environment.}

\item{globals}{Named list of objects to temporarily assign to the
global environment for the task. At the end of the task,
these values are reset to their previous values.}

\item{seed}{Integer of length 1 with the pseudo-random number generator
seed to temporarily set for the evaluation of the task.
At the end of the task, the seed is restored.}

\item{garbage_collection}{Logical, whether to run garbage collection
with \code{gc()} before running the task.}

\item{packages}{Character vector of packages to load for the task.}

\item{library}{Library path to load the packages. See the \code{lib.loc}
argument of \code{require()}.}
}
\value{
A monad object with results and metadata.
}
\description{
Not a user-side function. Do not call directly.
}
\details{
The \code{crew_eval()} function evaluates an R expression
in an encapsulated environment and returns a monad with the results,
including warnings and error messages if applicable.
The random number generator seed, \code{globals}, and global options
are restored to their original values on exit.
}
\examples{
crew_eval(quote(1 + 1))
}
\seealso{
Other utilities: 
\code{\link{crew_wait}()},
\code{\link{crew_worker}()}
}
\concept{utilities}
\keyword{internal}
