% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_launcher_sge.R
\name{crew_class_launcher_sge}
\alias{crew_class_launcher_sge}
\title{SGE launcher class}
\description{
\code{R6} class to launch and manage SGE workers.
}
\details{
See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.
}
\examples{

## ------------------------------------------------
## Method `crew_class_launcher_sge$script`
## ------------------------------------------------

launcher <- crew_launcher_sge(
  sge_cores = 2,
  sge_memory_gigabytes_required = 4
)
launcher$script()
}
\seealso{
Other launchers: 
\code{\link{crew_launcher_sge}()}
}
\concept{launchers}
\section{Super class}{
\code{\link[crew:crew_class_launcher]{crew::crew_class_launcher}} -> \code{crew_class_launcher_sge}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{sge_qsub}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_qdel}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_cwd}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_envvars}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_log_files}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_log_join}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_memory_gigabytes_required}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_memory_gigabytes_limit}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_cores}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_gpu}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_lines}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_launcher_sge-new}{\code{crew_class_launcher_sge$new()}}
\item \href{#method-crew_class_launcher_sge-launch_worker}{\code{crew_class_launcher_sge$launch_worker()}}
\item \href{#method-crew_class_launcher_sge-terminate_worker}{\code{crew_class_launcher_sge$terminate_worker()}}
\item \href{#method-crew_class_launcher_sge-validate}{\code{crew_class_launcher_sge$validate()}}
\item \href{#method-crew_class_launcher_sge-script}{\code{crew_class_launcher_sge$script()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="call"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-call'><code>crew::crew_class_launcher$call()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="expected"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-expected'><code>crew::crew_class_launcher$expected()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="launch"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-launch'><code>crew::crew_class_launcher$launch()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="launching"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-launching'><code>crew::crew_class_launcher$launching()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="settings"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-settings'><code>crew::crew_class_launcher$settings()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="start"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-start'><code>crew::crew_class_launcher$start()</code></a></span></li>
<li><span class="pkg-link" data-pkg="crew" data-topic="crew_class_launcher" data-id="terminate"><a href='../../crew/html/crew_class_launcher.html#method-crew_class_launcher-terminate'><code>crew::crew_class_launcher$terminate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_sge-new"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_sge-new}{}}}
\subsection{Method \code{new()}}{
SGE launcher constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_sge$new(
  name = NULL,
  seconds_launch = NULL,
  seconds_interval = NULL,
  seconds_timeout = NULL,
  seconds_idle = NULL,
  seconds_wall = NULL,
  seconds_exit = NULL,
  tasks_max = NULL,
  tasks_timers = NULL,
  reset_globals = NULL,
  reset_packages = NULL,
  reset_options = NULL,
  garbage_collection = NULL,
  sge_qsub = NULL,
  sge_qdel = NULL,
  sge_cwd = NULL,
  sge_envvars = NULL,
  sge_log_files = NULL,
  sge_log_join = NULL,
  sge_memory_gigabytes_required = NULL,
  sge_memory_gigabytes_limit = NULL,
  sge_cores = NULL,
  sge_gpu = NULL,
  sge_lines = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{seconds_launch}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{seconds_interval}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{seconds_timeout}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{seconds_idle}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{seconds_wall}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{seconds_exit}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{tasks_max}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{tasks_timers}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{reset_globals}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{reset_packages}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{reset_options}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{garbage_collection}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_qsub}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_qdel}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_cwd}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_envvars}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_log_files}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_log_join}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_memory_gigabytes_required}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_memory_gigabytes_limit}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_cores}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_gpu}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}

\item{\code{sge_lines}}{See \code{\link[=crew_launcher_sge]{crew_launcher_sge()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an SGE launcher object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_sge-launch_worker"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_sge-launch_worker}{}}}
\subsection{Method \code{launch_worker()}}{
Launch a local process worker which will
dial into a socket.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_sge$launch_worker(call, launcher, worker, instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{call}}{Text string with a namespaced call to \code{\link[=crew_worker]{crew_worker()}}
which will run in the worker and accept tasks.}

\item{\code{launcher}}{Character of length 1, name of the launcher.}

\item{\code{worker}}{Positive integer of length 1, index of the worker.
This worker index remains the same even when the current instance
of the worker exits and a new instance launches.
It is always between 1 and the maximum number of concurrent workers.}

\item{\code{instance}}{Character of length 1 to uniquely identify
the current instance of the worker.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
The \code{call} argument is R code that will run to
initiate the worker. Together, the \code{launcher}, \code{worker},
and \code{instance} arguments are useful for
constructing informative job names.
}

\subsection{Returns}{
A handle object to allow the termination of the worker
later on.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_sge-terminate_worker"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_sge-terminate_worker}{}}}
\subsection{Method \code{terminate_worker()}}{
Terminate a local process worker.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_sge$terminate_worker(handle)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{handle}}{A process handle object previously
returned by \code{launch_worker()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_sge-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_sge-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the launcher.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_sge$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly). Throws an error if a field is invalid.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_launcher_sge-script"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_launcher_sge-script}{}}}
\subsection{Method \code{script()}}{
Generate the job script.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_launcher_sge$script()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Includes everything except the worker-instance-specific
job name and the worker-instance-specific
call to \code{crew::crew_worker()} at the very bottom, which gets
inserted at launch time.
}

\subsection{Returns}{
Character vector of the lines of the job script.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{launcher <- crew_launcher_sge(
  sge_cores = 2,
  sge_memory_gigabytes_required = 4
)
launcher$script()
}
\if{html}{\out{</div>}}

}

}
}
