% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crest.reconstruct.R
\name{crest.reconstruct}
\alias{crest.reconstruct}
\title{Reconstruct climate from fossil data}
\usage{
crest.reconstruct(
  x,
  presenceThreshold = 0,
  taxWeight = "normalisation",
  uncertainties = c(0.5, 0.95),
  skip_for_loo = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{A \code{\link{crestObj}} produced by the
\code{\link{crest.calibrate}} function.}

\item{presenceThreshold}{All values above that threshold will be used in the
reconstruction (e.g. if set at 1, all percentages below 1 will be set
to 0 and the associated presences discarded). Default is 0.}

\item{taxWeight}{One value among the following: 'originalData',
'presence/absence', 'percentages' or 'normalisation' (default).}

\item{uncertainties}{A (vector of) threshold value(s) indicating the error
bars that should be calculated (default both 50 and 95\% ranges).}

\item{skip_for_loo}{A boolean that tells the \code{\link{loo}} function to
skip parts and fasten the process. Not for users, always leave to
\code{FALSE}.}

\item{verbose}{A boolean to print non-essential comments on the terminal
(default \code{TRUE}).}
}
\value{
A \code{\link{crestObj}} object containing the reconstructions and
all the associated data.
}
\description{
This function fits the climate response of the selected taxa to the selected
climate variables.
}
\examples{
data(crest_ex_pse)
data(crest_ex_selection)
data(crest_ex)
\dontrun{
  x <- crest.get_modern_data( df = crest_ex,
    pse = crest_ex_pse, taxaType = 0,
    climate = c("bio1", "bio12"),
    selectedTaxa = crest_ex_selection, dbname = "crest_example",
    verbose = FALSE
  )
  x <- crest.calibrate(x,
    geoWeighting = TRUE, climateSpaceWeighting = TRUE,
    bin_width = c(2, 50), shape = c("normal", "lognormal"),
    verbose = FALSE
  )
  x <- crest.reconstruct(x,
    verbose = FALSE)
  plot(x)
}

}
