% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.cranly_network}
\alias{summary.cranly_network}
\alias{summary_cranly_network}
\title{Compute a range of package directives and collaboration network statistics}
\usage{
\method{summary}{cranly_network}(object, advanced = TRUE, ...)
}
\arguments{
\item{object}{a \code{\link{cranly_network}} object.}

\item{advanced}{logical. If \code{\link{FALSE}} (default) only basic network statistics are computed; if \code{\link{TRUE}} advanced statistics are also included in the computation (see Details).}

\item{...}{currently not used`}
}
\value{
A \code{\link{data.frame}} of various statistics for the author collaboration
network or the package directives network, depending on whether
\code{attr(object, "perspective")} is \code{"author"} or
\code{"package"}, respectively. See Details for the current list of
statistics returned.
}
\description{
Compute a range of package directives and collaboration network statistics
}
\details{
If \code{attr(object, "perspective")} is \code{"package"} then the
resulting \code{data.frame} will have the following variables:
\itemize{
\item package. package name
\item n_authors (basic). number of authors for the package
\item n_imports (basic). number of packages the package imports
\item n_imported_by (basic). number of times the package is imported by other packages
\item n_suggests (basic). number of packages the package suggests
\item n_suggested_by (basic). number of times the package is suggested by other packages
\item n_depends (basic). number of packages the package depends on
\item n_depended_by (basic). number of packages that have the package as a dependency
\item n_enhances (basic). number of packages the package enhances
\item n_enhanced_by (basic). number of packages the package is enhanced by
\item n_linking_to (basic). number of packages the package links to
\item n_linked_by (basic). number of packages the package is linked by
\item betweenness (advanced). the package betweenness in the package network; as computed by \code{\link[igraph:betweenness]{igraph::betweenness()}}
\item closeness (advanced). the closeness centrality of the package in the package network; as computed by \code{\link[igraph:closeness]{igraph::closeness()}}
\item page_rank (advanced). the Google PageRank of the package in the package network; as computed by \code{\link[igraph:page_rank]{igraph::page_rank()}}
\item degree (advanced). the degree of the package in the package network;  as computed by \code{\link[igraph:degree]{igraph::degree()}}
\item eigen_centrality (advanced). the eigenvector centrality score of the package in the package network; as computed by \code{\link[igraph:eigen_centrality]{igraph::eigen_centrality()}}
}

If \code{attr(object, "perspective")} is \code{"author"} then the
resulting \code{data.frame} will have the following variables:
\itemize{
\item author. author name
\item n_packages (basic). number of packages the author appears in the package authors
\item n_collaborators (basic). total number of co-authors the author has in CRAN
\item betweenness (advanced). the author betweenness in the author network; as computed by \code{\link[igraph:betweenness]{igraph::betweenness()}}
\item closeness (advanced). the closeness centrality of the author in the author network; as computed by \code{\link[igraph:closeness]{igraph::closeness()}}
\item page_rank (advanced). the Google PageRank of the author in the author network; as computed by \code{\link[igraph:page_rank]{igraph::page_rank()}}
\item degree (advanced). the degree of the author in the author network;  as computed by \code{\link[igraph:degree]{igraph::degree()}}; same as n_collaborators
\item eigen_centrality (advanced). the eigenvector centrality score of the author in the author network; as computed by \code{\link[igraph:eigen_centrality]{igraph::eigen_centrality()}}
}
}
