% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxrt_functions.R
\name{coxph.RT}
\alias{coxph.RT}
\title{Fits Cox Regression Model Using Right Truncated Data}
\usage{
coxph.RT(formula, right, data, bs = FALSE, nbs.rep = 500,
  conf.int = 0.95)
}
\arguments{
\item{formula}{a formula object, with the response on the left of a ~ operator, and covariates on the right.
The response is a target lifetime variable.}

\item{right}{a right truncation variable.}

\item{data}{a data frame that includes the variables used in both sides of \code{formula}
and in \code{right}.
The observations with missing values in one of the variables are dropped.}

\item{bs}{logical value: if \code{TRUE}, the bootstrap esimator of standard error,
confidence interval,
and confidence upper and lower limits for one-sided confidence intervals
based on the bootstrap distribution are calculated. The default value is \code{FALSE}.}

\item{nbs.rep}{number of bootstrap replications. The default number is 500.}

\item{conf.int}{The confidence level for confidence intervals and hypotheses tests.
The default level is 0.95.}
}
\value{
A list with components:
\tabular{llr}{
\code{coef} \tab an estimate of regression coefficients \tab   \cr
\code{var} \tab covariance matrix of estimates of regression coefficients based on the analytic formula\tab  \cr
\code{n} \tab the number of observations used to fit the model \tab   \cr
\code{summary} \tab a data frame with a summary of fit: \tab  \cr}
\itemize{
\item{\code{coef}} a vector of coefficients
\item{\code{exp.coef}} exponent of regression coefficients (=hazard ratio)
\item{\code{SE}} asymptotic standard error estimate based on the analytic formula derived in Vakulenko-Lagun et al. (2018)
\item{\code{CI.L}} lower confidence limit for two-sided hypothesis \ifelse{html}{\out{H<sub>0</sub>:}}{\eqn{H_0}:} \ifelse{html}{\eqn{\beta}\out{<sub>i</sub>} = 0}{\eqn{\beta_i=0}}
\item{\code{CI.U}} upper confidence limit for two-sided hypothesis \ifelse{html}{\out{H<sub>0</sub>:}}{\eqn{H_0}:} \ifelse{html}{\eqn{\beta}\out{<sub>i</sub>} = 0}{\eqn{\beta_i=0}}
\item{\code{pvalue}} p-value from a Wald test for a two-sided hypothesis
\ifelse{html}{\out{H<sub>0</sub>:}}{\eqn{H_0}:}  \ifelse{html}{\eqn{\beta}\out{<sub>i</sub>} = 0}{\eqn{\beta_i=0}}
\item{\code{pvalue.H1.b.gr0}} p-value from the Wald test for a one-sided
partial hypothesis \ifelse{html}{\out{H<sub>0</sub>:}}{\eqn{H_0}:}  \ifelse{html}{\eqn{\beta}\out{<sub>i</sub>}\eqn{\le 0}}{\eqn{\beta_i\le 0}}
based on the analytical asymptotic standard error estimate
\item{\code{pvalue.H1.b.le0}} p-value from the Wald test a for one-sided
partial hypothesis \ifelse{html}{\out{H<sub>0</sub>:}}{\eqn{H_0}:} \ifelse{html}{\eqn{\beta}\out{<sub>i</sub>}\eqn{\ge 0}}{\eqn{\beta_i\ge 0}}
based on the analytical asymptotic standard error estimate }
\tabular{ll}{
\code{bs } \tab if the input argument \code{bs} was TRUE, then an output list also includes an element \code{bs} with\cr
 \tab statistics from the bootstrap distribution of estimated
 coefficients:\cr}
 \itemize{
\item{\code{num.bs.rep}}
{number of bootsrap replications used to obtain the sample distribution}
\item{\code{var}} {estimated variance}
\item{\code{summary}} {a data frame with a summary
of bootstrap distribution that includes:
 \code{SE}, a bootstrap estimated standard error;
 \code{CI.L},  a quantile estimated lower confidence limit
 for two-sided hypothesis \ifelse{html}{\out{H<sub>0</sub>:}}{\eqn{H_0}:} \ifelse{html}{\eqn{\beta}\out{<sub>i</sub>} = 0}{\eqn{\beta_i=0}};
 \code{CI.U}, a  quantile estimated upper confidence limit for two-sided hypothesis
\ifelse{html}{\out{H<sub>0</sub>:}}{\eqn{H_0}:}  \ifelse{html}{\eqn{\beta}\out{<sub>i</sub>} = 0}{\eqn{\beta_i=0}};
\code{CI.L.H1.b.gr0},
a quantile estimated the limit for one-sided hypothesis
\ifelse{html}{\out{H<sub>0</sub>:}}{\eqn{H_0}:} \ifelse{html}{\eqn{\beta}\out{<sub>i</sub>}\eqn{\le 0}}{\eqn{\beta_i\le 0}};
\code{CI.U.H1.b.le0}, a
quantile estimated the limit for one-sided hypothesis
\ifelse{html}{\out{H<sub>0</sub>:}}{\eqn{H_0}:} \ifelse{html}{\eqn{\beta}\out{<sub>i</sub>}\eqn{\ge 0}}{\eqn{\beta_i\ge 0}}.}
}
}
\description{
Estimates covariate effects in a Cox proportional hazard regression
from right-truncated survival data assuming positivity, that is
\code{P(lifetime>max(right) | Z=0)=0}.
}
\details{
When positivity does not hold, the estimator of regression coefficients
will be biased.
But if all the covariates are independent in the population,
the Wald test performed by this function is still valid and can be used
for testing partial hypotheses about regression coefficients
even in the absence of positivity. If the covariates are not independent and
positivity does not hold, the partial tests cannot guarantee the correct
level of type I error.
}
\examples{
# loading AIDS data set
library(gss)
data(aids)
all <- data.frame(age=aids$age, ageg=as.numeric(aids$age<=59), T=aids$incu,
R=aids$infe, hiv.mon =102-aids$infe)
all$T[all$T==0] <- 0.5 # as in Kalbfeisch and Lawless (1989)
s <- all[all$hiv.mon>60,] # select those who were infected in 1983 or later
# analysis assuming positivity
# we request bootstrap SE estimate as well:
sol <- coxph.RT(T~ageg, right=R, data=s, bs=FALSE)
sol
sol$summary # print the summary of fit based on the analytic Asymptotic Standard Error estimate

}
\seealso{
\code{\link{coxph.RT.a0}}, \code{\link{coxrt}}, \code{\link[survival]{coxph}}
}
