% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ahmad2015.R
\name{Ahmad2015}
\alias{Ahmad2015}
\title{Test of Structure of a Covariance Matrix given by Ahmad and Rosen 2015}
\usage{
Ahmad2015(x, Sigma = "identity", ...)
}
\arguments{
\item{x}{data}

\item{Sigma}{Population covariance matrix}

\item{...}{other options passed to covTest method}
}
\value{
A list with class "htest" containing the following components:

\tabular{ll}{
\code{statistic} \tab the value of equality of covariance test statistic \cr
\tab \cr
\code{parameter} \tab the degrees of freedom for the chi-squared statistic \cr
\tab \cr
\code{p.value} \tab the p=value for the test \cr
\tab \cr
\code{estimate} \tab the estimated covariances if less than 5 dimensions \cr
\tab \cr
\code{null.value} \tab the specified hypothesized value of the covariance difference \cr
\tab \cr
\code{alternative} \tab a character string describing the alternative hyposthesis \cr
\tab \cr
\code{method} \tab a character string indicating what type of equality of covariance test was performed \cr
\tab \cr
\code{data.name} \tab a character string giving the names of the data
}
}
\description{
Test of Structure of a Covariance Matrix given by Ahmad and Rosen 2015
}
\details{
The \code{\link{structureCovariances}} function is a wrapper function that formats the data 
  for the specific \code{covTest} functions.
}
\examples{
Ahmad2015(as.matrix(iris[1:50, 1:3]))

}
\references{
Ahmad, M. R. and Rosen, D. von. (2015). Tests for 
High-Dimensional Covariance Matrices Using the Theory of U-statistics. 
Journal of Statistical Computation and Simulation, 85(13), 2619-2631. 
\href{http://doi.org/10.1080/00949655.2014.948441}{10.1080/00949655.2014.948441}
}
