% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Schott2007.R
\name{Schott2007}
\alias{Schott2007}
\title{Test of Homogeneity of Covariance Matrices given by Schott 2007}
\usage{
Schott2007(x, ...)
}
\arguments{
\item{x}{data as a data frame, list of matrices, grouped data frame, or resample object}

\item{...}{other options passed to covTest method}
}
\value{
Test statistic of the hypothesis test
}
\description{
Test of Homogeneity of Covariance Matrices given by Schott 2007
}
\details{
The \code{\link{homogeneityCovariances}} function is a wrapper function that formats the data 
  for the specific \code{covTest} functions.
}
\examples{
irisSpecies <- unique(iris$Species)

iris_ls <- lapply(irisSpecies, 
    function(x){as.matrix(iris[iris$Species == x, 1:4])}
                 )
                 
names(iris_ls) <- irisSpecies

Schott2007(iris_ls)
}
\references{
Schott, J. (2007). A test for the equality of covariance matrices when the dimension is large relative to the sample sizes. Computational Statistics & Data Analysis, 51(12):6535-6542. \doi{10.1016/j.csda.2007.03.004}
}
