% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_keycol.R
\name{is_keycol}
\alias{is_keycol}
\title{Test whether a set of column could be a data frame key}
\usage{
is_keycol(x, cols, allow_NA = FALSE, verbose = TRUE)
}
\arguments{
\item{x}{A data frame object}

\item{cols}{A vector of column names or indices to be tested.}

\item{allow_NA}{Logical value indicating whether to allow key columns to have \code{NA} values. Default is \code{allow_NA=FALSE}, the function will return \code{FALSE} if any \code{NA} value is present in \code{colnames}.}

\item{verbose}{Logical value indicating whether messages should be printed on the console. Default is \code{TRUE}.}
}
\value{
Returns a logical value. If \code{TRUE}, the columns indicated in \code{colnames} uniquely identify the entries in \code{x}.
}
\description{
This function takes a data frame and a vector of column names as argument and returns a logical value indicating whether the indicated columns uniquely identify entries in the data frame.
If the output is \code{TRUE}, the indicated columns could be the keys of the table.
}
\examples{
is_keycol(data.frame(a=1:10,b=sample(c("a","b","c"),10, replace=TRUE)), cols="a")
is_keycol(data.frame(a=1:10,b=sample(c("a","b","c"),10, replace=TRUE)), cols="b")
is_keycol(
data.frame(a=c(1:5,1:5),
b=sample(c("a","b","c"),10, replace=TRUE),
c=c(rep("a",5),rep("b",5))),
cols=c("a","c"))
}
\seealso{
\link[countries]{find_keycol}, \link[countries]{find_countrycol}, \link[countries]{find_timecol}
}
