% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle.R
\name{ebicPlot}
\alias{ebicPlot}
\title{Extended Bayesian Information Criterion Plot}
\usage{
ebicPlot(fit, xlog = TRUE, col = "darkred")
}
\arguments{
\item{fit}{The model fit object from \code{mleLR()}}

\item{xlog}{TRUE or FALSE. Renders plot with the x-axis in the log-scale if \code{TRUE}}

\item{col}{Colour of the plot (character)}
}
\value{
Plot of the EBIC (y-axis) against each lambda (x-axis).
}
\description{
Plots the extended Bayesian information criterion (EBIC) of the model fit for
various penalization parameters \code{lambda}.
}
\examples{
data(singlecell)
mle <- mlePath(singlecell, tol=1e-4, tol.nr=1e-4, n.lambda = 2, n.cores = 1)

ebicPlot(mle, xlog = TRUE)

}
