% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_functions.R
\name{blm_star_exact}
\alias{blm_star_exact}
\title{Monte Carlo sampler for STAR linear regression with a g-prior}
\usage{
blm_star_exact(
  y,
  X,
  X_test = X,
  transformation = "np",
  y_max = Inf,
  psi = NULL,
  method_sigma = "mle",
  approx_Fz = FALSE,
  approx_Fy = FALSE,
  nsave = 5000,
  compute_marg = FALSE
)
}
\arguments{
\item{y}{\code{n x 1} vector of observed counts}

\item{X}{\code{n x p} matrix of predictors}

\item{X_test}{\code{n0 x p} matrix of predictors for test data}

\item{transformation}{transformation to use for the latent data; must be one of
\itemize{
\item "identity" (identity transformation)
\item "log" (log transformation)
\item "sqrt" (square root transformation)
\item "bnp" (Bayesian nonparametric transformation using the Bayesian bootstrap)
\item "np" (nonparametric transformation estimated from empirical CDF)
\item "pois" (transformation for moment-matched marginal Poisson CDF)
\item "neg-bin" (transformation for moment-matched marginal Negative Binomial CDF)
}}

\item{y_max}{a fixed and known upper bound for all observations; default is \code{Inf}}

\item{psi}{prior variance (g-prior)}

\item{method_sigma}{method to estimate the latent data standard deviation; must be one of
\itemize{
\item "mle" use the MLE from the STAR EM algorithm
\item "mmle" use the marginal MLE (Note: slower!)
}}

\item{approx_Fz}{logical; in BNP transformation, apply a (fast and stable)
normal approximation for the marginal CDF of the latent data}

\item{approx_Fy}{logical; in BNP transformation, approximate
the marginal CDF of \code{y} using the empirical CDF}

\item{nsave}{number of Monte Carlo simulations}

\item{compute_marg}{logical; if TRUE, compute and return the
marginal likelihood}
}
\value{
a list with the following elements:
\itemize{
\item \code{coefficients} the posterior mean of the regression coefficients
\item \code{post.beta}: \code{nsave x p} samples from the posterior distribution
of the regression coefficients
\item \code{post.pred}: draws from the posterior predictive distribution of \code{y}
\item \code{post.pred.test}: \code{nsave x n0} samples
from the posterior predictive distribution at test points \code{X_test}
(if given, otherwise NULL)
\item \code{sigma}: The estimated latent data standard deviation
\item \code{post.g}: \code{nsave} posterior samples of the transformation
evaluated at the unique \code{y} values (only applies for 'bnp' transformations)
\item \code{marg.like}: the marginal likelihood (if requested; otherwise NULL)
}
}
\description{
Compute direct Monte Carlo samples from the posterior and predictive
distributions of a STAR linear regression model with a g-prior.
}
\details{
STAR defines a count-valued probability model by
(1) specifying a Gaussian model for continuous *latent* data and
(2) connecting the latent data to the observed data via a
*transformation and rounding* operation. Here, the continuous
latent data model is a linear regression.

There are several options for the transformation. First, the transformation
can belong to the *Box-Cox* family, which includes the known transformations
'identity', 'log', and 'sqrt'. Second, the transformation
can be estimated (before model fitting) using the empirical distribution of the
data \code{y}. Options in this case include the empirical cumulative
distribution function (CDF), which is fully nonparametric ('np'), or the parametric
alternatives based on Poisson ('pois') or Negative-Binomial ('neg-bin')
distributions. For the parametric distributions, the parameters of the distribution
are estimated using moments (means and variances) of \code{y}. The distribution-based
transformations approximately preserve the mean and variance of the count data \code{y}
on the latent data scale, which lends interpretability to the model parameters.
Lastly, the transformation can be modeled using the Bayesian bootstrap ('bnp'),
which is a Bayesian nonparametric model and incorporates the uncertainty
about the transformation into posterior and predictive inference.

The Monte Carlo sampler produces direct, discrete, and joint draws
from the posterior distribution and the posterior predictive distribution
of the linear regression model with a g-prior.
}
\note{
The 'bnp' transformation (without the \code{Fy} approximation) is
slower than the other transformations because of the way
the \code{TruncatedNormal} sampler must be updated as the lower and upper
limits change (due to the sampling of \code{g}). Thus, computational
improvements are likely available.
}
\keyword{internal}
