% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wovr.R
\name{weighted.one.vs.rest}
\alias{weighted.one.vs.rest}
\title{Weighted One-Vs-Rest}
\usage{
weighted.one.vs.rest(X, C, classifier, predict_type_prob = "prob",
  wap_weights = FALSE, nthreads = 1, ...)
}
\arguments{
\item{X}{The data (covariates/features).}

\item{C}{matrix(n_samples, n_classes) Costs for each class for each observation.}

\item{classifier}{function(X, y, weights=w, ...) -> object, that would create a classifier with method `predict`.
The `y` vector passed to it is of class `integer` with values 0/1 only.}

\item{predict_type_prob}{argument to pass to method `predict` from the classifier passed to `classifier`
in order to output probabilities or numeric scores instead of classes
(i.e. `predict(object, newdata, type=predict_type_prob`)).}

\item{wap_weights}{Whether to use the weighting technique from the `Weighted-All-Pairs` algorithm.}

\item{nthreads}{Number of parallel threads to use (not available on Windows systems). Note
that, unlike the Python version, this is not a shared memory model and each additional thread will
require more memory from the system. Not recommended to use when the algorithm is itself parallelized.}

\item{...}{Extra arguments to pass to `classifier`.}
}
\description{
Creates a cost-sensitive classifier by creating one classifier per
class to predict cost. Takes as input a classifier accepting observation weights.
The objective is to create a model that would predict the
class with the minimum cost.
}
\examples{
\dontrun{
library(costsensitive)
wrapped.logistic <- function(X, y, weights, ...) {
	return(glm(y ~ ., data = X, weights = weights, family = "binomial", ...))
}
set.seed(1)
X <- data.frame(feature1 = rnorm(100), feature2 = rnorm(100), feature3 = runif(100))
C <- data.frame(cost1 = rgamma(100, 1), cost2 = rgamma(100, 1), cost3 = rgamma(100, 1))
model <- weighted.one.vs.rest(X, C, wrapped.logistic, predict_type_prob = "response")
predict(model, X, type = "class")
predict(model, X, type = "score")
print(model)
}
}
\references{
Beygelzimer, A., Dani, V., Hayes, T., Langford, J., & Zadrozny, B. (2005, August). Error limiting reductions between classification tasks.
}
