% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/ConvexCombCopula.R, R/Cort.R,
%   R/CortForest.R, R/cbCopula.R, R/cbkmCopula.R
\name{pCopula}
\alias{pCopula}
\alias{pCopula,matrix,ConvexCombCopula-method}
\alias{pCopula,matrix,Cort-method}
\alias{pCopula,matrix,CortForest-method}
\alias{pCopula,matrix,cbCopula-method}
\alias{pCopula,matrix,cbkmCopula-method}
\title{Copula cdf}
\usage{
pCopula(u, copula, ...)

\S4method{pCopula}{matrix,ConvexCombCopula}(u, copula)

\S4method{pCopula}{matrix,Cort}(u, copula)

\S4method{pCopula}{matrix,CortForest}(u, copula)

\S4method{pCopula}{matrix,cbCopula}(u, copula)

\S4method{pCopula}{matrix,cbkmCopula}(u, copula)
}
\arguments{
\item{u}{numeric matrix : one row per observation}

\item{copula}{the copula object}

\item{...}{other parameter to be passed to methods for this generic.}
}
\value{
The value of the copula on each observation
}
\description{
This function returns the value of the copula itself on given points.
}
\section{Functions}{
\itemize{
\item \code{pCopula,matrix,ConvexCombCopula-method}: Method for the cbCopula

\item \code{pCopula,matrix,Cort-method}: Method for the class Cort

\item \code{pCopula,matrix,CortForest-method}: Method for the class CortForest

\item \code{pCopula,matrix,cbCopula-method}: Method for the cbCopula

\item \code{pCopula,matrix,cbkmCopula-method}: Method for the cbCopula
}}

\examples{
cop <- cbCopula(cort::recoveryourself_data,m = 5)
pCopula(rep(0,2),cop) == 0
pCopula(rep(0.5,2),cop)
pCopula(rep(1,2),cop) == 1

}
