% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbkmCopula.R
\name{cbkmCopula-Class}
\alias{cbkmCopula-Class}
\alias{cbkmCopula}
\title{Checkerboard with known margins}
\usage{
cbkmCopula(
  x,
  m = rep(nrow(x), ncol(x)),
  pseudo = FALSE,
  margins_numbers = NULL,
  known_cop = NULL
)
}
\arguments{
\item{x}{the data to be used}

\item{m}{checkerboard parameter}

\item{pseudo}{Boolean, defaults to \code{FALSE}. Set to \code{TRUE} if you are already providing pseudo-data into the \code{x} argument.}

\item{margins_numbers}{numeric integers which determines the margins for the known copula.}

\item{known_cop}{Copula a copula object representing the known copula for the selected margins.}
}
\value{
a cbkmCopula object
}
\description{
cbkmCopula contructor
}
\details{
Given some empirical data, and given some known copula estimation on a sub-vector of this data,
the checkerboard with known margins construction consist in
a conditional pattern where the checkerboard part is conditional on the known part of the copula. See the corresponding vignette for more details.
}
\examples{
dataset <- apply(LifeCycleSavings,2,rank)/(nrow(LifeCycleSavings)+1)
known_copula <- cbCopula(dataset[,2:3],m=10)
(cop <- cbkmCopula(x = dataset,
                  m = 5,
                  pseudo = TRUE,
                  margins_numbers = c(2,3),
                  known_cop = known_copula))
}
