% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cort.R
\name{Cort-Class}
\alias{Cort-Class}
\alias{Cort}
\title{The Cort estimator}
\usage{
Cort(
  x,
  p_value_for_dim_red = 0.75,
  min_node_size = 1,
  pseudo_data = FALSE,
  number_max_dim = NULL,
  verbose_lvl = 1,
  slsqp_options = NULL
)
}
\arguments{
\item{x}{The data, must be provided as a matrix with each row as an observation.}

\item{p_value_for_dim_red}{a p_value for the localised dimension reduction test}

\item{min_node_size}{The minimum number of observation avaliable in a leaf to initialise a split.}

\item{pseudo_data}{set to True if you are already providing data on the copula space.}

\item{number_max_dim}{The maximum number of dimension a split occurs in. Defaults to be all of the dimensions.}

\item{verbose_lvl}{numeric. set the verbosity. 0 for no ouptut and bigger you set it the most output you get.}

\item{slsqp_options}{options for nloptr::slsqp to find breakpoints : you can change defaults.}
}
\value{
a Cort object that can be fitted easily to produce a copula estimate.
}
\description{
Cort class
}
\details{
This class implements the CORT algorithm to a fit a multivariate copula using piece constant density.
}
\examples{
(Cort(LifeCycleSavings[,1:3]))
}
