% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape.R
\name{stretch}
\alias{stretch}
\title{Stretch correlation data frame into long format.}
\usage{
stretch(x, na.rm = FALSE, remove.dups = FALSE)
}
\arguments{
\item{x}{cor_df. See \code{\link{correlate}}.}

\item{na.rm}{Boolean. Whether rows with an NA correlation (originally the
matrix diagonal) should be dropped? Will automatically be set to TRUE if
mirror is FALSE.}

\item{remove.dups}{Removes duplicate entries, without removing all NAs}
}
\value{
tbl with three columns (x and y variables, and their correlation)
}
\description{
\code{stretch} is a specified implementation of tidyr::gather() to be applied
to a correlation data frame. It will gather the columns into a long-format
data frame. The term column is handled automatically.
}
\examples{
x <- correlate(mtcars)
stretch(x) # Convert all to long format
stretch(x, na.rm = TRUE) # omit NAs (diagonal in this case)

x <- shave(x) # use shave to set upper triangle to NA and then...
stretch(x, na.rm = TRUE) # omit all NAs, therefore keeping each
# correlation only once.
}
