% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{network_plot}
\alias{network_plot}
\title{Network plot of a correlation data frame}
\usage{
network_plot(rdf, min_cor = 0.3, legend = TRUE,
  colours = c("indianred2", "white", "skyblue1"), repel = TRUE,
  curved = TRUE, colors)
}
\arguments{
\item{rdf}{Correlation data frame (see \code{\link{correlate}}) or object
that can be coerced to one (see \code{\link{as_cordf}}).}

\item{min_cor}{Number from 0 to 1 indicating the minimum value of
correlations (in absolute terms) to plot.}

\item{legend}{Boolean indicating whether a legend mapping the colors to the correlations should be displayed.}

\item{colours, colors}{Vector of colors to use for n-color gradient.}

\item{repel}{Should variable labels repel each other? If TRUE, text is added
via \code{\link[ggrepel]{geom_text_repel}} instead of \code{\link[ggplot2]{geom_text}}}

\item{curved}{Should the paths be curved? If TRUE, paths are added via
\code{\link[ggplot2]{geom_curve}}; if FALSE, via
\code{\link[ggplot2]{geom_segment}}}
}
\description{
Output a network plot of a correlation data frame in which variables that are
more highly correlated appear closer together and are joined by stronger
paths. Paths are also colored by their sign (blue for positive and red for
negative). The proximity of the points are determined using multidimensional
clustering.
}
\examples{
x <- correlate(mtcars)
network_plot(x)
network_plot(x, min_cor = .1)
network_plot(x, min_cor = .6)
network_plot(x, min_cor = .7, colors = c("red", "green"), legend = TRUE)
}
