% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{rplot}
\alias{rplot}
\title{Plot a correlation data frame.}
\usage{
rplot(x, print_cor, shape)
}
\arguments{
\item{x}{cor_df. See \code{\link{correlate}}.}

\item{print_cor}{Boolean indicating whether the correlations should be printed over the shapes.}

\item{shape}{\code{\link{geom_point}} aesthetic.}
}
\value{
Plots a correlation data frame
}
\description{
Plot a correlation data frame using ggplot.
}
\examples{
x <- correlate(mtcars)
rplot(x)

# Common use is following rearrange and shave
x <- rearrange(x, absolute = FALSE)
x <- shave(x)
rplot(x)
rplot(x, print_cor = TRUE)
}

